/*
 * Decompiled with CFR 0.152.
 */
package sdsu.net;

import java.io.DataInputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import sdsu.test.InteractiveProperties;

public class CGI {
    private Properties formData;
    private Properties cgiData;
    private PrintStream out = null;
    private static CGI instance = new CGI();

    private CGI() {
        String string = null;
        String string2 = System.getProperty("REQUEST_METHOD");
        if (string2 == null || string2.length() == 0) {
            this.formData = new InteractiveProperties();
            this.cgiData = new InteractiveProperties();
            return;
        }
        this.cgiData = System.getProperties();
        string = string2.equalsIgnoreCase("get") ? this.cgiData.getProperty("QUERY_STRING", "") : this.readCGIStandardIn();
        this.formData = this.tokenizeFormData(string);
    }

    public String decodeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringBuffer stringBuffer2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (n) {
                case 0: {
                    if (c == '+') {
                        stringBuffer.append(' ');
                        break;
                    }
                    if (c == '%') {
                        n = 1;
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 1: {
                    stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(c);
                    n = 2;
                    break;
                }
                case 2: {
                    stringBuffer2.append(c);
                    n = 0;
                    stringBuffer.append((char)Integer.parseInt(stringBuffer2.toString(), 16));
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getBaseURL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("http://");
        stringBuffer.append(((Hashtable)this.cgiData).get("SERVER_NAME"));
        if (!this.cgiData.getProperty("SERVER_PORT", "").equals("80")) {
            stringBuffer.append(":");
            stringBuffer.append(this.cgiData.getProperty("SERVER_PORT", ""));
        }
        stringBuffer.append(this.cgiData.getProperty("SCRIPT_NAME", ""));
        return stringBuffer.toString();
    }

    public Properties getCGIEnvironmentVariables() {
        return this.cgiData;
    }

    public Properties getFormData() {
        return this.formData;
    }

    public String getFullURL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getBaseURL());
        stringBuffer.append(this.cgiData.getProperty("PATH_INFO", ""));
        if (((Hashtable)this.cgiData).contains("QUERY_STRING")) {
            stringBuffer.append("?");
            stringBuffer.append(this.cgiData.getProperty("QUERY_STRING"));
        }
        return stringBuffer.toString();
    }

    public static CGI getInstance() {
        return instance;
    }

    public boolean isGetRequest() {
        String string = this.cgiData.getProperty("REQUEST_METHOD");
        return "GET".equalsIgnoreCase(string);
    }

    public boolean isPostRequest() {
        String string = this.cgiData.getProperty("REQUEST_METHOD");
        return "POST".equalsIgnoreCase(string);
    }

    public boolean isPutRequest() {
        String string = this.cgiData.getProperty("REQUEST_METHOD");
        return "PUT".equalsIgnoreCase(string);
    }

    private String readCGIStandardIn() {
        try {
            int n = Integer.parseInt(System.getProperty("CONTENT_LENGTH"));
            byte[] byArray = new byte[n];
            DataInputStream dataInputStream = new DataInputStream(System.in);
            dataInputStream.readFully(byArray, 0, n);
            return new String(byArray, 0);
        }
        catch (Exception exception) {
            this.sendText(exception.toString());
            return "";
        }
    }

    public void sendHtml(String string) {
        if (this.out == null) {
            this.out = System.out;
            this.out.print("Content-type: text/html\n\n");
        }
        this.out.println(string);
    }

    public static void sendRedirect(String string) {
        System.out.println("Location: " + string + "\n");
    }

    public void sendText(String string) {
        if (this.out == null) {
            this.out = System.out;
            this.out.print("Content-type: text/plain\n\n");
        }
        this.out.println(string);
    }

    private Properties tokenizeFormData(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            String string2 = stringTokenizer2.nextToken();
            if (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                ((Hashtable)properties).put(string2, this.decodeURL(string3));
                continue;
            }
            ((Hashtable)properties).put(string2, "");
        }
        return properties;
    }
}

