

[::Go back to Oozie Documentation Index::](index.html)

# Custom Action Nodes

<!-- MACRO{toc|fromDepth=1|toDepth=4} -->

## Introduction
Oozie can be extended to support additional action types by writing a custom [Action Node](WorkflowFunctionalSpec.html#ActionNodes). Action Nodes can be synchronous or asynchronous.

   * Synchronous Node - Sync nodes are executed inline by Oozie, which waits for completion of these nodes before proceeding. Hence, these nodes should almost never be used and are meant for lightweight tasks like FileSystem move, mkdir, delete.
   * Asynchronous Nodes - Oozie starts asynchronous nodes, and then monitors the action being executed for completion. This is done via a callback from the action or Oozie polling for the action status.

## Writing a custom Action Node
Action Executors are configured in the oozie configuration file oozie-site.xml. These executors are loaded during Oozie startup. [Deploying a Custom Action Executor](DG_CustomActionExecutor.html#Deploying_a_custom_Action_Executor).

Action Executors MUST extend the `ActionExecutor` class and override the required methods.

Most methods take as argument the Execution Context and the actual Action object with various configuration properties resolved.
### ActionExecutor.Context
The Execution context gives Action Nodes access to configuration properties, methods to set the state of the action, methods to set variables which are to be made available later in the execution path.

**The following methods from the ActionExecutor interface should be implemented.**
### Constructor
A no argument constructor should be implemented, which calls super(ACTION_TYPE). ACTION_TYPE is the name of the action which will be used in the workflow xml, and is used by Oozie to instantiate the correct type of Executor.

### initActionType()
This method is called once during initialization of the Action Executor during Oozie startup. Any common initialization code for the Action Node should go here.

As an example, setting up of error handling for the Custom Action should be done here.

This method must call super.initActionType() as it's first statement.

### start(ActionExecutor.Context context, Action action)
The action start up happens here.

   * Async Actions - The action should be started and context.setStartData(externalId, trackerUri, consoleUrl) must be set. A check can be made for whether the action has completed, in which case context.setExecutionData(externalStatus, actionData) must be called.
   * Sync Actions - The action should be started and should complete execution. context.setExecutionData(externalStatus, actionData) must be called.
### check(ActionExecutor.Context context, Action action)
`check(...)` is used by Oozie to poll for the status of the action. This method should interact with the action started previously, and update the status. If the action has completed, context.setExecutionData(externalStatus, actionData) must be called. Otherwise, the status can be updated using context.setExternalStatus(externalStatus).

For sync actions, this method will not be called, and should throw an UnsupportedOperationException().
### kill(ActionExecutor.Context context, Action action)
`kill(...)` is called when there is an attempt to kill the running job or action. No workflow transition is made after this.

The implementation for a custom action should interact with and kill the running action, and take care of any cleanup which may be required. context.setEndData(status, signalValue) should be called with both values set to Action.Status.KILLED.
### end(ActionExecutor.Context context, Action action)
`end(...)` is used for any cleanup or processing which may need to be done after completion of the action. After any processing, context.setEndData(status, signalValue) should be called to complete execution of the action and trigger the next workflow transition. signalValue can be Action.Status.OK or Action.Status.ERROR.
### Registering Errors
Oozie actions can generate different types of Errors.

   * TRANSIENT - will be retried
   * NON TRANSIENT - the job will be suspended and can be resumed later by human intervention, after fixing whatever problem caused this error.
   * ERROR - causes the error transition to be taken.
   * FAILED - the action and the job are set to FAILED state. No transitions are taken.
registerError(exceptionClassName, errorType, errorMessage) can be used to register possible exceptions while executing the action, along with their type and error message. This will normally be done during initialization of the Action Executor.

## Deploying a custom Action Executor
Action Nodes can be registered in the oozie configuration file oozie-site.xml, by changing the property 'oozie.service.ActionService.executor.ext.classes'. For multiple Executors, the class name should be separated by commas.

```  <property>
    <name>oozie.service.ActionService.executor.ext.classes</name>
    <value>
      org.apache.oozie.wf.action.decision.CustomActionExecutor,
	  Custom_Action_Executr_2.class
    </value>
  </property>
```
Any configuration properties to be made available to this class should also be added to oozie-site.xml. The convention to be followed for naming these properties is 'oozie.action.[ActionName].property.name'

The XML schema (XSD) for the new Actions should be added to oozie-site.xml, under the property 'oozie.service.WorkflowSchemaService.ext.schemas'. A comma separated list for multiple Action schemas.

The XML schema (XSD) for the new action should be also added to Fluent Job API. Please refer to
[Fluent Job API :: How To Extend](DG_FluentJobAPI.html#AE.C_Appendix_C_How_To_Extend) for details.

The executor class should be placed along with the oozie webapp in the correct path. Once Oozie is restarted, the custom action node can be used in workflows.



[::Go back to Oozie Documentation Index::](index.html)


