/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.oozie.executor.jpa;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.util.ParamChecker;

public class WorkflowActionRetryManualGetJPAExecutor implements JPAExecutor<List<WorkflowActionBean>> {

    private String wfId = null;
    List<WorkflowActionBean> actions;

    /**
     * This creates the WorkflowActionRetryManualGetJPAExecutor executor object.
     *
     * @param wfId
     */
    public WorkflowActionRetryManualGetJPAExecutor(String wfId) {
        ParamChecker.notNull(wfId, "wfId");
        this.wfId = wfId;
        this.actions = null;
    }

    @Override
    public List<WorkflowActionBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_RETRY_MANUAL_ACTIONS");
            q.setParameter("wfId", wfId);
            actions = q.getResultList();
        }
        catch (IllegalStateException e) {
            throw new JPAExecutorException(ErrorCode.E0601, e.getMessage(), e);
        }
        return actions;
    }

    @Override
    public String getName() {
        return "WorkflowActionRetryManualGetJPAExecutor";
    }
}
