set hive.mapred.mode=nonstrict;
-- start query 1 in stream 0 using template query20.tpl and seed 345591136
explain
select  i_item_desc 
       ,i_category 
       ,i_class 
       ,i_current_price
       ,i_item_id
       ,sum(cs_ext_sales_price) as itemrevenue 
       ,sum(cs_ext_sales_price)*100/sum(sum(cs_ext_sales_price)) over
           (partition by i_class) as revenueratio
 from catalog_sales
     ,item 
     ,date_dim
 where cs_item_sk = i_item_sk 
   and i_category in ('Jewelry', 'Sports', 'Books')
   and cs_sold_date_sk = d_date_sk
 and d_date between cast('2001-01-12' as date) 
 				and (cast('2001-01-12' as date) + 30 days)
 group by i_item_id
         ,i_item_desc 
         ,i_category
         ,i_class
         ,i_current_price
 order by i_category
         ,i_class
         ,i_item_id
         ,i_item_desc
         ,revenueratio
limit 100;

-- end query 1 in stream 0 using template query20.tpl
-- this query has been modified so that i_item_id is included in the select clause; this is necessary because CDH Hive
-- does not support ordering by unselected columns; upstream Hive has this feature (HIVE-15160), but it is CBO specific
