/*
 * Copyright 2013 NGDATA nv
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ngdata.hbaseindexer.parse;

import org.apache.solr.common.SolrInputDocument;

/**
 * Writes documents to a Solr server.
 */
public interface SolrUpdateWriter {
    
    /**
     * Write a single SolrInputDocument.
     * 
     * @param solrDocument document to be written
     */
    void add(SolrInputDocument solrDocument);

    void deleteById(String documentId);

    void deleteByQuery(String query);

}
