/*
 * Decompiled with CFR 0.152.
 */
package org.pyant.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.pyant.tasks.PythonTestTask;

public class PythonCoverageTask
extends PythonTestTask {
    protected File coverage;
    private FileSet tests;
    private FileSet src;
    protected File reportsdir;
    private String[] pythonCmd = null;
    private File testDriver;
    private String[] env;
    private List srcList = new ArrayList();

    public void setCoverage(File file) {
        this.coverage = file;
    }

    public void addTests(FileSet fileSet) {
        if (this.tests != null) {
            throw new BuildException("Only one FileSet allowed in <tests>");
        }
        this.tests = fileSet;
    }

    public void addSrc(FileSet fileSet) {
        if (this.src != null) {
            throw new BuildException("Only one FileSet allowed in <src>");
        }
        this.src = fileSet;
    }

    public void setReportsdir(File file) {
        this.reportsdir = file;
    }

    private void setup() {
        if (this.coverage == null) {
            throw new BuildException("Coverage not defined");
        }
        this.pythonCmd = new String[]{this.getPython(), "-u", "-O", this.coverage.getAbsolutePath()};
        this.env = new String[]{"PYTHONPATH=" + this.pythonpath.toString()};
        this.log("PYTHONPATH=" + this.pythonpath, 3);
        try {
            this.testDriver = File.createTempFile("testDriver", ".py");
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.testDriver));
            printWriter.println("import unittest");
            printWriter.println("import sys");
            printWriter.println("if __name__  == '__main__':");
            printWriter.println("\targv = sys.argv[1:]");
            printWriter.println("\tprint \"testDriver called with \" + ''.join(argv)");
            printWriter.println("\tunittest.main(module=__import__(sys.argv[1]), defaultTest=None, argv=[sys.argv[0]])");
            printWriter.close();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        this.log("Test driver: " + this.testDriver);
    }

    private void report(String string) throws IOException, InterruptedException {
        Object object;
        this.log("Creating report for: " + string);
        File file = this.reportsdir;
        if (string != null && !(file = new File(file, new File(string).getName())).mkdir()) {
            throw new BuildException("Cannot create " + file);
        }
        String string2 = string == null ? this.getProject().getName() : string;
        PrintWriter printWriter = new PrintWriter(new FileWriter(new File(file, string == null ? "index2.html" : "index.html")));
        printWriter.println("<html><head><title>" + string2 + "</title></head>");
        printWriter.println("<body><h1>" + string2 + "</h1>");
        printWriter.println("<table border=1>");
        printWriter.println("<tr><th>File</th><th>Statements</th><th>Exec</th><th>Cover %</th></tr>");
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < this.srcList.size(); i += 10) {
            arrayList2.clear();
            arrayList2.add("-r");
            for (int j = i; j < (i + 10 > this.srcList.size() ? this.srcList.size() : i + 10); ++j) {
                object = (FileResource)this.srcList.get(j);
                File file2 = new File(object.getBaseDir(), object.getName());
                arrayList2.add(file2.getAbsolutePath());
            }
            Object object2 = this.executeCoverage(arrayList2.toArray(new String[0]));
            object = new StdoutCollector((Process)object2);
            ((Thread)object).start();
            while (!((StdoutCollector)object).isDone()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            arrayList.addAll(((StdoutCollector)object).coverageDataList);
            ((Process)object2).waitFor();
            arrayList2.set(0, "-d");
            arrayList2.add(1, file.getAbsolutePath());
            arrayList2.add(2, "-a");
            this.simpleExecuteCoverage(arrayList2.toArray(new String[0]));
            for (int j = 3; j < arrayList2.size(); ++j) {
                File file3 = new File(arrayList2.get(j).toString());
                File file4 = new File(file, file3.getName() + ",cover");
                File file5 = new File(file, file3.getName() + ".html");
                PrintWriter printWriter2 = new PrintWriter(new FileWriter(file5));
                printWriter2.println("<html><head/><body>");
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file4));
                String string3 = "";
                boolean bl = true;
                while ((string3 = bufferedReader.readLine()) != null) {
                    String string4 = "#FFFFFF";
                    if (string3.startsWith(">") || string3.startsWith("!")) {
                        string4 = string3.charAt(0) == '>' ? "#00FF00" : "#FF0000";
                        string3 = string3.substring(1);
                    }
                    string3 = string3.replaceAll(" ", "&nbsp;");
                    printWriter2.println("<span style='font-style: \"Courier New\"; background-color: " + string4 + "'>" + string3 + "</span><br/>");
                }
                printWriter2.println("</body></html>");
                printWriter2.close();
                bufferedReader.close();
            }
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                CoverageData coverageData = (CoverageData)object;
                CoverageData coverageData2 = (CoverageData)object2;
                int n2 = Integer.parseInt(coverageData.cover.substring(0, coverageData.cover.length() - 1));
                return n2 == (n = Integer.parseInt(coverageData2.cover.substring(0, coverageData2.cover.length() - 1))) ? 0 : (n2 > n ? -1 : 1);
            }
        });
        for (Object object2 : arrayList) {
            this.log(((CoverageData)object2).file + " " + ((CoverageData)object2).statements + " " + ((CoverageData)object2).exec + " " + ((CoverageData)object2).cover);
            object = new File(((CoverageData)object2).file).getName() + ".py.html";
            printWriter.print("<tr><td><a href=" + (String)object + ">" + ((CoverageData)object2).file + "</a></td>");
            printWriter.print("<td>" + ((CoverageData)object2).statements + "</td>");
            printWriter.print("<td>" + ((CoverageData)object2).exec + "</td>");
            printWriter.print("<td>" + ((CoverageData)object2).cover + "</td>");
            printWriter.println("</tr>");
            printWriter.flush();
        }
        printWriter.println("</table>");
        printWriter.println("</body></html>");
        printWriter.close();
    }

    private void runCoverage(String string) throws IOException, InterruptedException {
        string = string.substring(0, string.length() - 3);
        if (!this.packagedtests) {
            string = string.substring(string.lastIndexOf(File.separatorChar) + 1);
        }
        string = string.replaceAll("\\\\", ".");
        string = string.replaceAll("/", ".");
        this.log("Running coverage on " + string);
        this.simpleExecuteCoverage(new String[]{"-x", this.testDriver.getAbsolutePath(), string});
    }

    private void simpleExecuteCoverage(String[] stringArray) {
        Process process = this.executeCoverage(stringArray);
        try {
            final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            final BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
            new Thread(){

                @Override
                public void run() {
                    String string = "";
                    try {
                        while ((string = bufferedReader.readLine()) != null) {
                            PythonCoverageTask.this.log("stderr> " + string, 3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PythonCoverageTask.this.log("stderr Done", 3);
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    String string = "";
                    try {
                        while ((string = bufferedReader2.readLine()) != null) {
                            PythonCoverageTask.this.log("stdout> " + string, 3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    PythonCoverageTask.this.log("stdout Done", 3);
                }
            }.start();
            System.out.flush();
            System.err.flush();
            int n = process.waitFor();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private void eraseCoverage() {
        this.log("Erasing coverage");
        this.simpleExecuteCoverage(new String[]{"-e"});
    }

    private Process executeCoverage(String[] stringArray) {
        int n;
        String[] stringArray2 = new String[this.pythonCmd.length + stringArray.length];
        for (n = 0; n < this.pythonCmd.length; ++n) {
            stringArray2[n] = this.pythonCmd[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[this.pythonCmd.length + n] = stringArray[n];
        }
        File file = new File(System.getProperty("user.dir"));
        this.log("Executing in " + file + ":\n\t" + Arrays.asList(stringArray2).toString().replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(",", " "), 3);
        IOException iOException = null;
        for (int i = 0; i < 5; ++i) {
            try {
                Process process = Runtime.getRuntime().exec(stringArray2, this.env, file);
                return process;
            }
            catch (IOException iOException2) {
                this.log("Problem running coverage", iOException2, 2);
                this.log("Will try again...");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                iOException = iOException2;
                continue;
            }
        }
        throw new BuildException(iOException);
    }

    @Override
    public void execute() {
        try {
            String string;
            Object object3;
            this.setup();
            this.srcList = new ArrayList();
            Object object2 = this.src.iterator();
            while (object2.hasNext()) {
                this.srcList.add(object2.next());
            }
            object2 = new ArrayList();
            this.log("Doing test-by-test reports");
            for (Object object3 : this.tests) {
                string = new File(object3.getBaseDir(), object3.getName()).getAbsolutePath();
                this.eraseCoverage();
                this.log(new Date() + " Executing test: " + string);
                object2.add(new File(string).getName());
                this.runCoverage(string);
                this.report(string);
            }
            this.log("Doing cumulative report");
            this.eraseCoverage();
            for (Object object3 : this.tests) {
                string = new File(object3.getBaseDir(), object3.getName()).getAbsolutePath();
                this.log("Executing test: " + string);
                this.runCoverage(string);
            }
            this.report(null);
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(this.reportsdir, "index.html")));
            printWriter.println("<html><head><title>Coverage report</title></head><body>");
            printWriter.println("<h3>Reports</h3>");
            printWriter.println("<ul>");
            printWriter.println("<h3><a href=index2.html>Cumulative report</a></h3>");
            printWriter.println("<hr/>");
            printWriter.println("<h3>Report by test</h3>");
            printWriter.println("<ul>");
            object3 = object2.iterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                printWriter.println("<li><A href=" + string + "/index.html>" + string + "</li>");
            }
            printWriter.println("</ul>");
            printWriter.println("</body></html>");
            printWriter.close();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    private class StdoutCollector
    extends Thread {
        private boolean done = false;
        private boolean error = false;
        private BufferedReader stdout;
        private List coverageDataList = new ArrayList();

        public synchronized boolean isDone() {
            return this.done;
        }

        private StdoutCollector(Process process) {
            this.stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string = null;
            try {
                int n = 0;
                while ((string = this.stdout.readLine()) != null) {
                    if (n >= 2) {
                        if (string.startsWith("------")) break;
                        String[] stringArray = string.split("[ \t]+");
                        PythonCoverageTask.this.log("Result: " + Arrays.asList(stringArray).toString(), 4);
                        CoverageData coverageData = new CoverageData();
                        coverageData.file = stringArray[0];
                        coverageData.statements = stringArray[1];
                        coverageData.exec = stringArray[2];
                        coverageData.cover = stringArray[3];
                        this.coverageDataList.add(coverageData);
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {
                StdoutCollector stdoutCollector = this;
                synchronized (stdoutCollector) {
                    PythonCoverageTask.this.log("Error: " + iOException);
                    this.error = true;
                }
            }
            StdoutCollector stdoutCollector = this;
            synchronized (stdoutCollector) {
                this.done = true;
            }
        }
    }

    private class CoverageData {
        String file;
        String statements;
        String exec;
        String cover;

        private CoverageData() {
        }

        public String toString() {
            return "<Coverage for " + this.file + ": " + this.statements + ", " + this.exec + "," + this.cover + ">";
        }
    }
}

