/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.spark.sql.execution.metric

import com.fasterxml.jackson.annotation.{JsonIgnore, JsonProperty}

import org.apache.spark.annotation.DeveloperApi

/**
 * :: DeveloperApi ::
 * Stores information about a SQL Metric.
 */
@DeveloperApi
class SQLMetricInfo(
    val name: String,
    val accumulatorId: Long,
    _type: String) {

  // CDH-46123: compatibility for C5-generated event logs.
  @JsonProperty("metricType")
  private var _metricType = _type

  @JsonProperty("metricParam")
  private def setMetricParam(value: String): Unit = {
    _metricType = value
  }

  @JsonIgnore
  def metricType: String = _metricType

}
