/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.parquet;

import java.io.Closeable;
import java.io.IOException;

/**
 * Utilities for managing I/O resources.
 */
public class IOExceptionUtils {

	/**
	 * Call the #close() method on a {@see Closable}, wrapping any IOException
	 * in a runtime exception.
	 *
	 * @param closeable - resource to close
	 */
	public static void closeQuietly(Closeable closeable) {
		try {
			closeable.close();
		} catch(IOException e) {
			throw new ParquetRuntimeException("Error closing I/O related resources.", e) {};
		}
	}

}
