/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.oozie.coord;

public class CoordELConstants {
    /*
     * Echo backing some constants used in Coordinator EL variables
     */
    public static final String SUBMIT_MINUTE = "${MINUTE}";
    public static final String SUBMIT_HOUR = "${HOUR}";
    public static final String SUBMIT_MONTH = "${MONTH}";
    public static final String SUBMIT_DAY = "${DAY}";
    public static final String SUBMIT_YEAR = "${YEAR}";

    public static final int SUBMIT_MINUTES = 1;
    public static final int SUBMIT_HOURS = 60;
    public static final int SUBMIT_DAYS = 24 * 60;

    public static final String DEFAULT_DONE_FLAG = "_SUCCESS";
    final public static String RESOLVED_PATH = "resolved_path";

    final public static String IS_RESOLVED = "is_resolved";
}
