/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.UnpauseTransitionXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;

import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor.CoordJobQuery;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;

public class CoordUnpauseXCommand extends UnpauseTransitionXCommand {
    private final JPAService jpaService = Services.get().get(JPAService.class);
    private final CoordinatorJobBean coordJob;
    private CoordinatorJob.Status prevStatus = null;

    public CoordUnpauseXCommand(CoordinatorJobBean coordJob) {
        super("coord_unpause", "coord_unpause", 1);
        this.coordJob = coordJob;
    }

    @Override
    public String getEntityKey() {
        return coordJob.getId();
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public void loadState() throws CommandException {
        prevStatus = coordJob.getStatus();
        LogUtils.setLogInfo(coordJob);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    public void notifyParent() throws CommandException {
        // update bundle action
        if (coordJob.getBundleId() != null) {
            BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(coordJob, prevStatus);
            bundleStatusUpdate.call();
        }
    }

    @Override
    public Job getJob() {
        return coordJob;
    }

    @Override
    public void updateJob() throws CommandException {
        try {
            CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQuery.UPDATE_COORD_JOB_STATUS, coordJob);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public void unpauseChildren() throws CommandException {
        // TODO - need revisit when revisiting coord job status redesign;

    }

    @Override
    public void performWrites() throws CommandException {
    }

}
