/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hive.spark.client.metrics;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.spark.executor.TaskMetrics;

import java.io.Serializable;

/**
 * Metrics pertaining to writing data.
 */
@InterfaceAudience.Private
public class OutputMetrics implements Serializable {

  /** Total number of bytes written. */
  public final long bytesWritten;
  /** Total number of records written. */
  public final long recordsWritten;

  private OutputMetrics() {
    // For Serialization only.
    this(0L, 0L);
  }

  public OutputMetrics(long bytesWritten, long recordsWritten) {
    this.bytesWritten = bytesWritten;
    this.recordsWritten = recordsWritten;
  }

  public OutputMetrics(TaskMetrics metrics) {
    this(metrics.outputMetrics().bytesWritten(), metrics.outputMetrics().recordsWritten());
  }

  @Override
  public String toString() {
    return "OutputMetrics{" +
            "bytesWritten=" + bytesWritten +
            ", recordsWritten=" + recordsWritten +
            '}';
  }
}
