/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.sqoop.testutil;

import java.util.Objects;

import static org.apache.commons.lang3.StringUtils.isEmpty;

public class Argument {

  private final String name;

  private final String value;

  public Argument(String name) {
    this(name, "");
  }

  public Argument(String name, String value) {
    Objects.requireNonNull(name);
    this.name = name;
    this.value = value;
  }

  public String getName() {
    return name;
  }

  public String getValue() {
    return value;
  }

  public static Argument fromPair(String name, String value) {
    return new Argument(name, value);
  }

  public static Argument from(String name) {
    return new Argument(name);
  }

  @Override
  public String toString() {
    if (isEmpty(value)) {
      return name;
    } else {
      return String.format("%s=%s", name, value);
    }
  }
}
