#!/bin/bash
#
#
# Copyright 2011 The Apache Software Foundation
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Arguments are:
#    path to the root of the build directory
#    the version number
#    the git hash of the current checkout. If empty, auto-detect.
#
# e.g., $ write-version-info.sh ./build/ 1.0.0

buildroot=$1
version=$2
specifiedgithash=$3

newoutputdir="${buildroot}/src/org/apache/sqoop"
newoutputfile="${newoutputdir}/SqoopVersion.java"

signature=$specifiedgithash
if [ -z "$signature" ]; then
  signature=`git log -1 --pretty=format:%H`
fi

host=`hostname`
compiledate=`date`

mkdir -p "${newoutputdir}"
cat > "${newoutputfile}" <<EOF
// generated by src/scripts/write-version-info.sh
package org.apache.sqoop;

public class SqoopVersion {
  public SqoopVersion() {
  }

  public static final String VERSION="${version}";
  public static final String GIT_HASH="${signature}";
  public static final String COMPILE_USER="${USER}";
  public static final String COMPILE_DATE="${compiledate}";

  @Override
  public String toString() {
    return "Sqoop " + VERSION + "\n"
        + "git commit id " + GIT_HASH + "\n"
        + "Compiled by " + COMPILE_USER
        + " on " + COMPILE_DATE + "\n";
  }
}
EOF
