#!/bin/bash
#
# Copyright 2011 The Apache Software Foundation
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

CLOUDERA_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

export GRADLE_ARGUMENTS="-Dorg.gradle.daemon=false \
                         -DignoreTestFailures=true \
                         -Ds3.bucket.url=${SQOOP_S3_BUCKET_URL} \
                         -Ds3.generator.command=${CLOUDERA_DIR}/get-temporary-aws-s3-credentials.sh \
                         -Dabfs.container.url=$SQOOP_ABFS_URL \
                         -Dabfs.generator.command=${CLOUDERA_DIR}/get-azure-credentials.sh \
                         -Dadl.container.url=$SQOOP_ADL_URL \
                         -Dadl.generator.command=${CLOUDERA_DIR}/get-azure-credentials.sh \
                         $GRADLE_ARGUMENTS"

# Run tests in the AbfsTest, AdlTest, S3Test categories
$CLOUDERA_DIR/../gradlew $GRADLE_ARGUMENTS abfsTest adlTest s3Test

if [[ $? -ne 0 ]]; then
  echo "Error executing test task. Aborting!"
  exit 1
fi
