/*
 * Decompiled with CFR 0.152.
 */
package prantl.ant.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import prantl.ant.eclipse.EclipseOutput;
import prantl.ant.eclipse.EclipseTask;

class FileEclipseOutput
extends EclipseOutput {
    private EclipseTask task;

    FileEclipseOutput(EclipseTask parent) {
        super(parent.getEclipse());
        this.task = parent;
    }

    OutputStream createClassPath() {
        return this.createFile(".classpath");
    }

    private OutputStream createFile(String name) {
        File output = this.resolveFile(name);
        try {
            this.task.log("Creating the file \"" + output.getAbsolutePath() + "\".", 3);
            FileUtils.getFileUtils().createNewFile(output, true);
            return new FileOutputStream(output);
        }
        catch (IOException exception) {
            throw new BuildException("Creation of the file \"" + output.getAbsolutePath() + "\" falied.", (Throwable)exception);
        }
    }

    OutputStream createPreferences(String name) {
        return this.createFile(".settings/" + name + ".prefs");
    }

    OutputStream createProject() {
        return this.createFile(".project");
    }

    boolean isClassPathUpToDate() {
        return this.isFileUpToDate(".classpath");
    }

    private boolean isFileUpToDate(String name) {
        return !this.getEclipse().isUpdateAlways() && FileUtils.getFileUtils().isUpToDate(this.resolveFile(this.task.getProject().getProperty("ant.file")), this.resolveFile(name));
    }

    boolean isPreferencesUpToDate(String name) {
        return this.isFileUpToDate(".settings/" + name + ".prefs");
    }

    boolean isProjectUpToDate() {
        return this.isFileUpToDate(".project");
    }

    InputStream openClassPath() {
        return this.openFile(".classpath");
    }

    private InputStream openFile(String name) {
        File input = this.resolveFile(name);
        try {
            this.task.log("Opening the file \"" + input.getAbsolutePath() + "\".", 3);
            return new FileInputStream(input);
        }
        catch (FileNotFoundException exception) {
            throw new BuildException("The file \"" + input.getAbsolutePath() + "\" was not found.", (Throwable)exception);
        }
    }

    InputStream openPreferences(String name) {
        return this.openFile(".settings/" + name + ".prefs");
    }

    InputStream openProject() {
        return this.openFile(".project");
    }

    private File resolveFile(String name) {
        FileUtils utils = FileUtils.getFileUtils();
        return utils.resolveFile(utils.resolveFile(this.task.getProject().getBaseDir(), this.getEclipse().getDestDir().getName()), name);
    }
}

