/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sentry.api.generic.thrift;

import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.api.common.ApiConstants.SentryPolicyServiceConstants;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import org.apache.sentry.service.thrift.ProcessorFactory;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;

public class SentryGenericPolicyProcessorFactory extends ProcessorFactory {

  public SentryGenericPolicyProcessorFactory(Configuration conf) {
    super(conf);
  }

  @Override
  public boolean register(TMultiplexedProcessor multiplexedProcessor,
                          SentryStoreInterface _) throws Exception {
    SentryGenericPolicyProcessor processHandler = new SentryGenericPolicyProcessor(conf);
    TProcessor processor = new SentryGenericPolicyProcessorWrapper<SentryGenericPolicyService.Iface>(
        processHandler);
    multiplexedProcessor.registerProcessor(
        SentryPolicyServiceConstants.SENTRY_GENERIC_SERVICE_NAME, processor);
    return true;
  }

}
