CREATE TABLE "SENTRY_USER" (
  "USER_ID" NUMBER  NOT NULL,
  "USER_NAME" VARCHAR2(128) NOT NULL,
  "CREATE_TIME" NUMBER NOT NULL
);

ALTER TABLE "SENTRY_USER"
  ADD CONSTRAINT "SENTRY_USER_PK" PRIMARY KEY ("USER_ID");

ALTER TABLE "SENTRY_USER"
  ADD CONSTRAINT "SENTRY_USER_USER_NAME_UNIQUE" UNIQUE ("USER_NAME");

CREATE TABLE "SENTRY_ROLE_USER_MAP" (
  "ROLE_ID" NUMBER NOT NULL,
  "USER_ID" NUMBER NOT NULL,
  "GRANTOR_PRINCIPAL" VARCHAR2(128)
);

ALTER TABLE "SENTRY_ROLE_USER_MAP"
  ADD CONSTRAINT "SENTRY_ROLE_USER_MAP_PK" PRIMARY KEY ("ROLE_ID","USER_ID");

ALTER TABLE "SENTRY_ROLE_USER_MAP"
  ADD CONSTRAINT "SEN_ROLE_USER_MAP_SEN_ROLE_FK"
  FOREIGN KEY ("ROLE_ID") REFERENCES "SENTRY_ROLE"("ROLE_ID") INITIALLY DEFERRED;

ALTER TABLE "SENTRY_ROLE_USER_MAP"
  ADD CONSTRAINT "SEN_ROLE_USER_MAP_SEN_USER_FK"
  FOREIGN KEY ("USER_ID") REFERENCES "SENTRY_USER"("USER_ID") INITIALLY DEFERRED;