/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.sentry.service.common;

import static org.apache.sentry.service.common.ServiceConstants.ServerConfig.SENTRY_DB_POLICY_STORE_OWNER_AS_PRIVILEGE;
import static org.apache.sentry.service.common.ServiceConstants.ServerConfig.SENTRY_DB_POLICY_STORE_OWNER_AS_PRIVILEGE_DEFAULT;

import org.apache.hadoop.conf.Configuration;

/**
 * Controls the owner privileges feature for DB policies.
 */
public enum SentryOwnerPrivilegeType {
  NONE,             // New DB objects do not get owner privileges
  ALL,              // New DB objects will get owner privileges as 'all'
  ALL_WITH_GRANT;    // New DB objects will get owner privileges as 'all with grant'

  /**
   * Checks if the Configuration object has the owner privilege type configuration set.
   *
   * @param conf The Configuration object where to check if the config is set.
   * @return True if it is set; False otherwise.
   */
  public boolean isConfSet(Configuration conf) {
    return (this == get(conf));
  }

  /**
   * Returns the owner privilege type from the Configuration object.
   *
   * @param conf The Configuration object where to search for the owner privilege type.
   * @return The SentryOwnerPrivilegeType object.
   */
  public static SentryOwnerPrivilegeType get(Configuration conf) {
    return SentryOwnerPrivilegeType.valueOf(getConfigValue(conf).toUpperCase());
  }

  /**
   * Returns the owner privilege string type from the Configuration object.
   *
   * @param conf The Configuration object where to search for the owner privilege type.
   * @return The string value of the owner privilege type.
   */
  private static String getConfigValue(Configuration conf) {
    return conf.get(SENTRY_DB_POLICY_STORE_OWNER_AS_PRIVILEGE,
      SENTRY_DB_POLICY_STORE_OWNER_AS_PRIVILEGE_DEFAULT.toString());
  }
}
