/*
 * Copyright 2013 Cloudera Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kitesdk.data.spi.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.avro.Schema;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.spi.CharSequences;

/**
 * @deprecated Kite DataSet API is deprecated as of CDH6.0.0 and will be removed from CDH in an upcoming release.
 * Cloudera recommends that you use the equivalent API in Spark instead of the Kite DataSet API.
 */
@Deprecated
public abstract class Predicates {
  @SuppressWarnings("unchecked")
  public static <T> Exists<T> exists() {
    return (Exists<T>) Exists.INSTANCE;
  }

  @SuppressWarnings("unchecked")
  public static <T> In<T> in(Set<T> set) {
    T item = Iterables.getFirst(set, null);
    if (item != null && item instanceof CharSequence) {
      return (In<T>) new In(new CharSequences.ImmutableCharSequenceSet(
          (Set<CharSequence>) set));
    }
    return new In<T>(set);
  }

  @SuppressWarnings("unchecked")
  public static <T> In<T> in(T... set) {
    T item = set[0];
    if (item != null && item instanceof CharSequence) {
      return (In<T>) new In(new CharSequences.ImmutableCharSequenceSet(set));
    }
    return new In<T>(set);
  }

  public static <T> String toString(Predicate<T> predicate, Schema schema) {
    if (predicate instanceof Exists) {
      return "";
    } else if (predicate instanceof Range) {
      return ((Range) predicate).toString(schema);
    } else if (predicate instanceof In) {
      String values = ((In) predicate).toString(schema);
      if (values.length() != 0) {
        return values;
      }
      // "" is a special case that conflicts with exists, use the named version
      return "in()";
    } else if (predicate instanceof RegisteredPredicate) {
      return RegisteredPredicate.toString(
          (RegisteredPredicate) predicate, schema);
    } else {
      throw new DatasetException("Unknown predicate: " + predicate);
    }
  }

  public static <T> String toNormalizedString(Predicate<T> predicate, Schema schema) {
    if (predicate instanceof Exists) {
      return "";
    } else if (predicate instanceof Range) {
      return ((Range) predicate).toString(schema);
    } else if (predicate instanceof In) {
      String values = ((In) predicate).toNormalizedString(schema);
      if (values.length() != 0) {
        return values;
      }
      // "" is a special case that conflicts with exists, use the named version
      return "in()";
    } else if (predicate instanceof RegisteredPredicate) {
      return RegisteredPredicate.toNormalizedString(
          (RegisteredPredicate) predicate, schema);
    } else {
      throw new DatasetException("Unknown predicate: " + predicate);
    }
  }

  public static <T> Predicate<T> fromString(String pString, Schema schema) {
    if (pString.length() == 0) {
      return exists();
    }
    Predicate<T> predicate = Range.fromString(pString, schema);
    if (predicate != null) {
      return predicate;
    }
    predicate = RegisteredPredicate.fromString(pString, schema);
    if (predicate != null) {
      return predicate;
    }
    predicate = In.fromString(pString, schema);
    if (predicate != null) {
      return predicate;
    }
    throw new DatasetException("Unknown predicate: " + pString);
  }

  public static <T> Set<T> asSet(In<T> in) {
    return in.getSet();
  }
}
