/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;

/**
 * Runs arbitrary background logic inside the metastore service.  
 */
@InterfaceAudience.LimitedPrivate({"Hive"})
@InterfaceStability.Evolving
public interface HouseKeeperService {
  public void start(HiveConf hiveConf) throws Exception;
  /**
   * Should perform orderly shutdown
   */
  public void stop();
  /**
   * Returns short description of services this module provides.
   */
  public String getServiceDescription();

  /**
   * This is incremented each time the service is performed.  Can be useful to
   * check if serivce is still alive.
   */
  public int getIsAliveCounter();
}
