/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.sentry.spi;

import java.util.List;

/**
 * This is the ProviderLoader interface to allow for multiple different Provider Loading mechanics.
 *
 * This was borrowed from and inspired by the Keycloak SPI implmentation
 * http://www.keycloak.org
 * original Author <a href="mailto:sthorger@redhat.com">Stian Thorgersen</a>
 */
public interface ProviderLoader {

  /**
   * Load the SPI definitions themselves.
   *
   * @return a list of Spi definition objects
   */
  List<Spi> loadSpis();

  /**
   * Load all provider factories of a specific SPI.
   *
   * @param spi the Spi definition
   * @return a list of provider factories
   */
  List<ProviderFactory> load(Spi spi);

}
