/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.oozie.command;

import org.apache.oozie.client.Job;

/**
 * This is transition Base commands for all the jobs.
 */
public abstract class KillTransitionXCommand<T> extends TransitionXCommand<T> {
    protected T ret;

    public KillTransitionXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    public abstract void killChildren() throws CommandException;

    @Override
    public void transitToNext() {
        if (job == null) {
            job = this.getJob();
        }
        job.setStatus(Job.Status.KILLED);
        job.setPending();
    }

    @Override
    protected T execute() throws CommandException {
        try {
            transitToNext();
            killChildren();
            updateJob();
            performWrites();
        }
        finally {
            notifyParent();
        }
        return ret;
    }
}
