set hive.mapred.mode=nonstrict;
-- start query 1 in stream 0 using template query42.tpl and seed 1819994127
explain
select  dt.d_year
 	,item.i_category_id
 	,item.i_category
 	,sum(ss_ext_sales_price) as s
 from 	date_dim dt
 	,store_sales
 	,item
 where dt.d_date_sk = store_sales.ss_sold_date_sk
 	and store_sales.ss_item_sk = item.i_item_sk
 	and item.i_manager_id = 1  	
 	and dt.d_moy=12
 	and dt.d_year=1998
 group by 	dt.d_year
 		,item.i_category_id
 		,item.i_category
 order by       s desc,dt.d_year
 		,item.i_category_id
 		,item.i_category
limit 100 ;

-- end query 1 in stream 0 using template query42.tpl
-- this query has been modified so that sum(ss_ext_sales_price) has an alias and the query is ordered on this alias;
-- functionally, the query is exactly the same. This is necessary because CDH Hive does not support ordering by
-- unselected columns; upstream Hive has this feature (HIVE-15160), but it is CBO specific
