/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.File;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.glite.security.util.CAFilenameSplitter;
import org.glite.security.util.CaseInsensitiveProperties;
import org.glite.security.util.CertificateNotFoundException;
import org.glite.security.util.FullTrustAnchor;
import org.glite.security.util.TrustDirHandler;

public class TrustStorage {
    static final Logger LOGGER = Logger.getLogger((String)TrustStorage.class.getName());
    private static final int INITIAL_CA_VECTOR_SIZE = 400;
    Hashtable<String, Vector<FullTrustAnchor>> m_trustStore = new Hashtable(400);
    String m_storagePath = null;
    boolean m_preloaded = false;
    private boolean m_updating;
    private CaseInsensitiveProperties m_props;

    public TrustStorage(String storagePath) throws IOException, CertificateException, ParseException {
        this.m_storagePath = storagePath;
        this.checkUpdate();
        if (this.m_trustStore.isEmpty()) {
            throw new IOException("No certificate authority files were found from: " + storagePath);
        }
    }

    public TrustStorage(String storagePath, CaseInsensitiveProperties props) throws IOException, CertificateException, ParseException {
        this.m_props = props;
        this.m_storagePath = storagePath;
        this.checkUpdate();
        if (this.m_trustStore.isEmpty()) {
            throw new IOException("No certificate authority files were found from: " + storagePath);
        }
    }

    private synchronized boolean setUpdating() {
        boolean oldValue = this.m_updating;
        this.m_updating = true;
        return oldValue;
    }

    private synchronized boolean releaseUpdating() {
        boolean oldValue = this.m_updating;
        this.m_updating = false;
        return oldValue;
    }

    public FullTrustAnchor[] getAnchors(String hash) {
        Vector<FullTrustAnchor> anchors = this.m_trustStore.get(hash);
        if (anchors == null) {
            return null;
        }
        return anchors.toArray(new FullTrustAnchor[0]);
    }

    public void loadAnchors() throws IOException, CertificateException, ParseException {
        Hashtable<String, Vector<FullTrustAnchor>> tempStore = new Hashtable<String, Vector<FullTrustAnchor>>(400);
        TrustDirHandler dirHandler = new TrustDirHandler(this.m_storagePath);
        dirHandler.init();
        File[] files = dirHandler.getCAs();
        int i = 0;
        while (i < files.length) {
            FullTrustAnchor anchor;
            String file = files[i].getAbsolutePath();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Loading CA: " + file));
            }
            try {
                anchor = new FullTrustAnchor(file, this.m_props);
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn((Object)("Error loading a CA from: " + file + ", CA not enabled. Error was: " + e.getMessage()), (Throwable)e);
                } else {
                    LOGGER.warn((Object)("Error loading a CA from: " + file + ", CA not enabled. Error was: " + e.getMessage()));
                }
                ++i;
                continue;
            }
            Vector<FullTrustAnchor> anchors = (Vector<FullTrustAnchor>)tempStore.get(anchor.m_caHash);
            if (anchors == null) {
                anchors = new Vector<FullTrustAnchor>();
            }
            anchors.add(anchor);
            tempStore.put(anchor.m_caHash, anchors);
            ++i;
        }
        this.m_trustStore = tempStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkUpdate() throws IOException, CertificateException, ParseException {
        try {
            FullTrustAnchor anchor;
            if (this.setUpdating()) {
                return;
            }
            TrustDirHandler dirHandler = new TrustDirHandler(this.m_storagePath);
            dirHandler.init();
            File[] files = dirHandler.getCAs();
            String[] filenames = new String[files.length];
            for (int n = 0; n < files.length; ++n) {
                filenames[n] = files[n].getAbsolutePath();
            }
            int i = 0;
            while (i < filenames.length) {
                String filename = filenames[i];
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Checking a CA for update, processing file: " + filename));
                }
                CAFilenameSplitter parts = CAFilenameSplitter.splitCAFilename(filename);
                Vector<FullTrustAnchor> cas = this.m_trustStore.get(parts.m_hash);
                if (cas == null) {
                    LOGGER.debug((Object)("Adding new anchor from file: " + filename));
                    try {
                        anchor = new FullTrustAnchor(filename, this.m_props);
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)("Error loading a CA from: " + filename + ", CA not enabled. Error was: " + e.getMessage()));
                        ++i;
                        continue;
                    }
                    Vector<FullTrustAnchor> newVector = new Vector<FullTrustAnchor>();
                    newVector.add(anchor);
                    this.m_trustStore.put(parts.m_hash, newVector);
                    ++i;
                    continue;
                }
                boolean found = false;
                for (FullTrustAnchor anchor2 : cas) {
                    if (anchor2.m_caNumber != parts.m_number) continue;
                    found = true;
                    try {
                        anchor2.checkUpdate();
                    }
                    catch (CertificateNotFoundException e) {
                        LOGGER.info((Object)("CA file: " + filename + "." + parts.m_number + ", was removed. Disabling the CA."));
                        cas.remove(anchor2);
                    }
                    catch (CertificateException e) {
                        LOGGER.warn((Object)("Loading of CA file: " + filename + "." + parts.m_number + ", failed. Disabling the CA. Error was: " + e.getMessage()));
                        cas.remove(anchor2);
                    }
                    catch (Exception e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.warn((Object)("Error loading a CA from: " + filename + " number " + parts.m_number + ", CA not fully updated. Error was: " + e + ": " + e.getMessage()), (Throwable)e);
                            break;
                        }
                        LOGGER.warn((Object)("Error loading a CA from: " + filename + " number " + parts.m_number + ", CA not fully updated. Error was: " + e + ": " + e.getMessage()));
                    }
                    break;
                }
                if (!found) {
                    FullTrustAnchor anchor2;
                    try {
                        anchor2 = new FullTrustAnchor(filename, this.m_props);
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)("Error loading a CA from: " + filename + ", CA not enabled. Error was: " + e.getMessage()));
                        ++i;
                        continue;
                    }
                    cas.add(anchor2);
                }
                ++i;
            }
            Iterator<Vector<FullTrustAnchor>> iter = this.m_trustStore.values().iterator();
            while (iter.hasNext()) {
                Vector<FullTrustAnchor> anchors = iter.next();
                Iterator<FullTrustAnchor> numberIter = anchors.iterator();
                while (numberIter.hasNext()) {
                    int n;
                    anchor = numberIter.next();
                    for (n = 0; n < filenames.length && !filenames[n].equals(anchor.m_baseFilename + "." + anchor.m_caNumber); ++n) {
                    }
                    if (n != filenames.length) continue;
                    numberIter.remove();
                }
                if (!anchors.isEmpty()) continue;
                iter.remove();
            }
        }
        finally {
            if (!this.releaseUpdating()) {
                LOGGER.fatal((Object)"Internal synchronization violation, two trustanchor updaters mixing.");
                throw new RuntimeException("Internal synchronization violation, two trustanchor updaters mixing.");
            }
        }
    }

    public FullTrustAnchor[] getAnchors() {
        if (this.m_trustStore.isEmpty()) {
            return null;
        }
        Enumeration<Vector<FullTrustAnchor>> enumer = this.m_trustStore.elements();
        Vector trustAnchors = new Vector();
        while (enumer.hasMoreElements()) {
            trustAnchors.addAll(enumer.nextElement());
        }
        if (trustAnchors.isEmpty()) {
            return null;
        }
        return trustAnchors.toArray(new FullTrustAnchor[0]);
    }
}

