/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.proxy;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class ProxyPolicy
extends ASN1Encodable {
    public static final String INHERITALL_POLICY_OID = "1.3.6.1.5.5.7.21.1";
    public static final String INDEPENDENT_POLICY_OID = "1.3.6.1.5.5.7.21.2";
    public static final String LIMITED_PROXY_OID = "1.3.6.1.4.1.3536.1.1.1.9";
    private String m_oid = "1.3.6.1.5.5.7.21.1";
    private ASN1OctetString m_policy = null;

    public ProxyPolicy(String oid) {
        this.m_oid = oid;
    }

    public ProxyPolicy(String oid, ASN1OctetString policy) {
        if (oid != null) {
            this.m_oid = oid;
        }
        this.m_policy = policy;
    }

    public ProxyPolicy(ASN1Sequence seq) {
        if (seq != null && seq.size() > 0) {
            if (!(seq.getObjectAt(0) instanceof DERObjectIdentifier)) {
                throw new IllegalArgumentException("ProxyPolicy parser error, expected object identifier, but got:" + seq.getObjectAt(0).getClass());
            }
        } else {
            throw new IllegalArgumentException("ProxyPolicy parser error, expected nonempty sequence, but not no sequence or an empty sequence");
        }
        this.m_oid = seq.getObjectAt(0).toString();
        if (seq.size() > 1) {
            if (seq.getObjectAt(1) instanceof DEROctetString) {
                this.m_policy = (ASN1OctetString)seq.getObjectAt(1);
            } else {
                throw new IllegalArgumentException("ProxyPolicy parser error, expected octetstring but got: " + seq.getObjectAt(1).getClass());
            }
        }
        if (seq.size() > 2) {
            throw new IllegalArgumentException("ProxyPolicy parser error, proxy policy can only have two items, got: " + seq.size() + "items.");
        }
    }

    public String getPolicyOID() {
        return this.m_oid;
    }

    public ASN1OctetString getPolicyASN1() {
        return this.m_policy;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)new DERObjectIdentifier(this.m_oid));
        if (this.m_policy != null) {
            v.add((DEREncodable)new DEROctetString((DEREncodable)this.m_policy));
        }
        return new DERSequence(v);
    }
}

