/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.glite.security.trustmanager.CRLCertChecker;
import org.glite.security.util.DN;
import org.glite.security.util.DNHandler;

public class ProxyCertPathValidator {
    private static final Logger LOGGER = Logger.getLogger((String)ProxyCertPathValidator.class.getName());
    Vector trustAnchors;
    CertificateFactory certFact = CertificateFactory.getInstance("X.509", "BC");
    CRLCertChecker crlChecker = null;

    public ProxyCertPathValidator(Vector trustAnchors) throws CertificateException, NoSuchProviderException {
        this.trustAnchors = trustAnchors;
    }

    public void setCRLChecker(CRLCertChecker checker) {
        this.crlChecker = checker;
    }

    public void check(X509Certificate[] inpath) throws CertPathValidatorException, CertificateException {
        int n;
        DN caSubject;
        Vector<Certificate> pathVect = new Vector<Certificate>();
        for (int i = 0; i < inpath.length; ++i) {
            byte[] bytes = inpath[i].getEncoded();
            BufferedInputStream certIS = new BufferedInputStream(new ByteArrayInputStream(bytes));
            pathVect.add(this.certFact.generateCertificate(certIS));
        }
        X509Certificate[] path = pathVect.toArray(new X509Certificate[0]);
        if (LOGGER.isDebugEnabled()) {
            for (int i = 0; i < path.length; ++i) {
                LOGGER.debug((Object)("input path cert type: " + path[i].getClass().getName() + " DN [" + path[i].getSubjectDN() + "]"));
            }
        }
        int len = path.length;
        LOGGER.debug((Object)("path len is " + len));
        if (len == 0) {
            LOGGER.error((Object)"No certificate given to check");
            throw new CertPathValidatorException("No certificate given to check");
        }
        X509Certificate caCert = path[len - 1];
        DN caIssuer = DNHandler.getIssuer(caCert);
        if (caIssuer.equals(caSubject = DNHandler.getSubject(caCert))) {
            LOGGER.debug((Object)("cert " + caSubject + " considered as CA cert (came with the chain from client)"));
            if (--len == 0) {
                TrustAnchor[] anchor = this.findCA(caSubject);
                TrustAnchor acceptedAnchor = null;
                for (int n2 = 0; n2 < anchor.length; ++n2) {
                    if (!anchor[n2].getTrustedCert().equals(caCert)) continue;
                    acceptedAnchor = anchor[n2];
                    break;
                }
                if (acceptedAnchor == null) {
                    LOGGER.error((Object)("A self signed cert [" + caSubject + "] given, but not found among CAs, rejecting"));
                    throw new CertPathValidatorException("A self signed cert [" + caSubject + "] given, but not found among CAs, rejecting");
                }
                try {
                    caCert.checkValidity();
                }
                catch (CertificateException e) {
                    LOGGER.info((Object)("the CA Certificate " + caSubject + " expired on " + caCert.getNotAfter()));
                    throw new CertificateExpiredException("the CA Certificate " + DNHandler.getSubject(caCert) + " expired on " + caCert.getNotAfter());
                }
                LOGGER.info((Object)("certificate path for " + caSubject + " is valid"));
                return;
            }
        }
        LOGGER.debug((Object)"Checking for expiration in the chain");
        for (int n3 = 0; n3 < path.length; ++n3) {
            try {
                path[n3].checkValidity();
                continue;
            }
            catch (CertificateExpiredException e) {
                LOGGER.info((Object)("the Certificate for " + DNHandler.getSubject(path[n3]) + " expired on " + path[n3].getNotAfter()));
                throw new CertificateExpiredException("the Certificate for " + DNHandler.getSubject(path[n3]) + " expired on " + path[n3].getNotAfter());
            }
            catch (CertificateNotYetValidException e) {
                LOGGER.info((Object)("the Certificate for " + DNHandler.getSubject(path[n3]) + " will only be valid after " + path[n3].getNotBefore()));
                throw new CertificateExpiredException("the Certificate for " + DNHandler.getSubject(path[n3]) + " will only be valid after " + path[n3].getNotBefore());
            }
        }
        X509Certificate last = path[len - 1];
        boolean namingConstraint = false;
        DN caDN = DNHandler.getIssuer(last);
        DN lastDN = DNHandler.getSubject(last);
        TrustAnchor[] anchor = this.findCA(caDN);
        LOGGER.debug((Object)("found " + anchor.length + " CAs that match, cheking which to use"));
        boolean acceptAnchor = false;
        Exception thrown = null;
        try {
            for (n = 0; n < anchor.length; ++n) {
                try {
                    namingConstraint = this.checkLastAnchor(last, anchor[n]);
                }
                catch (Exception e) {
                    if (e instanceof CRLException) {
                        throw (CRLException)e;
                    }
                    thrown = e;
                    continue;
                }
                acceptAnchor = true;
            }
        }
        catch (CRLException e) {
            LOGGER.info((Object)("Certificate for [" + lastDN + "] revoked by [" + caDN + "], rejecting it"));
            throw new CertPathValidatorException(e.getMessage());
        }
        if (!acceptAnchor) {
            if (thrown != null) {
                LOGGER.error((Object)("While checking against CA [" + caDN + "] got exception" + thrown));
                throw new CertPathValidatorException("While checking against CA [" + caDN + "] got exception " + thrown + " " + thrown.getMessage());
            }
            LOGGER.info((Object)("CA cert [" + caDN + "] not found, rejecting certificate for [" + lastDN + "]"));
            throw new CertPathValidatorException("CA cert [" + caDN + "] not found, rejecting certificate for [" + lastDN + "]");
        }
        LOGGER.debug((Object)"checking the rest of the chain");
        try {
            for (n = len - 1; n > 0; --n) {
                namingConstraint = this.checkCertificatePair(path[n - 1], path[n], namingConstraint);
            }
        }
        catch (CertPathValidatorException e) {
            LOGGER.info((Object)e.getMessage());
            throw e;
        }
        catch (CertificateException e) {
            LOGGER.info((Object)e.getMessage());
            throw e;
        }
        LOGGER.debug((Object)("certificate path for " + DNHandler.getSubject(path[0]) + " is valid"));
    }

    public void checkSignature(X509Certificate sub, X509Certificate signer) throws CertPathValidatorException, CertificateException {
        LOGGER.debug((Object)"Checking the signature");
        PublicKey signKey = signer.getPublicKey();
        LOGGER.debug((Object)("Sub cert is " + sub.getClass().getName()));
        try {
            sub.verify(signKey);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.info((Object)("Invalid signature algorithm in \"" + ((Object)sub.getSubjectDN()).toString() + "\" error was " + e.getClass().getName() + ":" + e.getMessage()));
            throw new CertificateException("Invalid signature algorithm in \"" + ((Object)sub.getSubjectDN()).toString() + "\" error was " + e.getClass().getName() + ":" + e.getMessage());
        }
        catch (InvalidKeyException e) {
            LOGGER.info((Object)("Invalid public key in \"" + ((Object)signer.getSubjectDN()).toString() + "\" error was " + e.getClass().getName() + ":" + e.getMessage()));
            throw new CertificateException("Invalid public key in \"" + ((Object)signer.getSubjectDN()).toString() + "\" error was " + e.getClass().getName() + ":" + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            LOGGER.error((Object)("Internal error, no crypto provider found. Error was " + e.getClass().getName() + ":" + e.getMessage()));
            throw new CertificateException("Internal error, no crypto provider found. Error was " + e.getMessage());
        }
        catch (SignatureException e) {
            LOGGER.info((Object)("invalid signature in " + ((Object)sub.getSubjectDN()).toString()));
            throw new CertPathValidatorException("invalid signature in " + ((Object)sub.getSubjectDN()).toString());
        }
    }

    public boolean checkCertificatePair(X509Certificate sub, X509Certificate signer, boolean namingConstraint) throws CertPathValidatorException, CertificateException {
        LOGGER.debug((Object)"Checking a cert pair");
        this.checkSignature(sub, signer);
        DN subIssuer = DNHandler.getIssuer(sub);
        DN signerSubject = DNHandler.getSubject(signer);
        LOGGER.debug((Object)"Checking DN match");
        if (!subIssuer.equals(signerSubject)) {
            LOGGER.info((Object)("cert issuer DN (" + subIssuer + ") - Issuer subject DN (" + signerSubject + ") mismatch subject was "));
            throw new CertPathValidatorException("cert issuer DN (" + subIssuer + ") - Issuer subject DN (" + signerSubject + ") mismatch subject was ");
        }
        if (namingConstraint) {
            LOGGER.debug((Object)("Checkin that " + DNHandler.getSubject(signer) + " matches end of " + DNHandler.getSubject(sub) + " because either constraints were true [" + namingConstraint + "] or signer basicContraints was equal to -1 [" + signer.getBasicConstraints() + "]"));
            this.checkDNRestriction(sub, signer);
            return true;
        }
        LOGGER.debug((Object)("Certificate for \"" + DNHandler.getSubject(sub) + "\" is OK"));
        if (sub.getVersion() == 1) {
            return true;
        }
        return sub.getBasicConstraints() == -1;
    }

    public boolean checkLastAnchor(X509Certificate sub, TrustAnchor anchor) throws CertPathValidatorException, CertificateException, CRLException {
        LOGGER.debug((Object)"Checkin last cert and anchor");
        boolean namingConstraints = false;
        X509Certificate caCert = anchor.getTrustedCert();
        namingConstraints = this.checkCertificatePair(sub, caCert, false);
        if (this.crlChecker != null) {
            this.crlChecker.check((Certificate)sub, (Collection)null);
        }
        LOGGER.debug((Object)("Certificate for \"" + DNHandler.getSubject(sub) + "\" is validly issued by CA \"" + DNHandler.getSubject(caCert) + "\""));
        return namingConstraints;
    }

    public TrustAnchor[] findCA(DN dn) throws CertPathValidatorException, CertificateParsingException {
        Iterator anchorIter = this.trustAnchors.iterator();
        Vector<TrustAnchor> found = new Vector<TrustAnchor>();
        boolean caExpired = false;
        while (anchorIter.hasNext()) {
            TrustAnchor current = (TrustAnchor)anchorIter.next();
            DN anchorDN = DNHandler.getSubject(current.getTrustedCert());
            if (!anchorDN.equals(dn)) continue;
            try {
                current.getTrustedCert().checkValidity();
            }
            catch (CertificateExpiredException e) {
                caExpired = true;
                LOGGER.warn((Object)("The CA certificate for " + anchorDN + " has expired, update or remove it!"));
                continue;
            }
            catch (CertificateNotYetValidException e) {
                caExpired = true;
                LOGGER.warn((Object)("The CA certificate for " + anchorDN + " is not yet valid!"));
                continue;
            }
            found.add(current);
        }
        TrustAnchor[] accepted = new TrustAnchor[]{};
        if (found.size() > 0) {
            if (caExpired) {
                LOGGER.warn((Object)("Remove expired duplicate certificate(s) for CA " + dn));
            }
            return found.toArray(accepted);
        }
        if (caExpired) {
            LOGGER.error((Object)("The CA certificate for " + dn + " has expired or is not yet valid, update or remove it!"));
        }
        LOGGER.info((Object)("No CA named \"" + dn + "\" could be found"));
        throw new CertPathValidatorException("No CA named \"" + dn + "\" could be found");
    }

    public X509Certificate[] getCACerts() {
        Iterator iter = this.trustAnchors.iterator();
        Vector<X509Certificate> certs = new Vector<X509Certificate>();
        while (iter.hasNext()) {
            TrustAnchor anchor = (TrustAnchor)iter.next();
            X509Certificate cert = anchor.getTrustedCert();
            certs.add(cert);
        }
        LOGGER.debug((Object)("getCACerts: returning " + certs.size() + " ca certs"));
        return certs.toArray(new X509Certificate[0]);
    }

    public void checkDNRestriction(X509Certificate sub, X509Certificate signer) throws CertificateException {
        LOGGER.debug((Object)"Checking dn restriction");
        DN subDN = DNHandler.getSubject(sub);
        DN signerDN = DNHandler.getSubject(signer);
        try {
            DN subDNWithoutProxy = subDN.withoutLastCN(false);
            if (!subDNWithoutProxy.equals(signerDN)) {
                throw new CertificateException("The DN [" + subDN + "] doesn't end with [" + signerDN + "] as required for proxy certs");
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("Error while cheking naming constrainst between sub [" + subDN + "] and signer [" + signerDN + " error: " + e + e.getMessage()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"StackTrace: ", (Throwable)e);
            }
            if (e instanceof CertificateException) {
                throw (CertificateException)e;
            }
            throw new CertificateException("Error while cheking naming constrainst between sub [" + subDN + "] and signer [" + signerDN + "] error: " + e + e.getMessage());
        }
    }
}

