/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <activemq/wireformat/openwire/marshal/v2/ConsumerControlMarshaller.h>

#include <activemq/commands/ConsumerControl.h>
#include <activemq/exceptions/ActiveMQException.h>
#include <decaf/lang/Pointer.h>

//
//     NOTE!: This file is autogenerated - do not modify!
//            if you need to make a change, please see the Java Classes in the
//            activemq-core module
//

using namespace std;
using namespace activemq;
using namespace activemq::exceptions;
using namespace activemq::commands;
using namespace activemq::wireformat;
using namespace activemq::wireformat::openwire;
using namespace activemq::wireformat::openwire::marshal;
using namespace activemq::wireformat::openwire::utils;
using namespace activemq::wireformat::openwire::marshal::v2;
using namespace decaf;
using namespace decaf::io;
using namespace decaf::lang;

///////////////////////////////////////////////////////////////////////////////
DataStructure* ConsumerControlMarshaller::createObject() const {
    return new ConsumerControl();
}

///////////////////////////////////////////////////////////////////////////////
unsigned char ConsumerControlMarshaller::getDataStructureType() const {
    return ConsumerControl::ID_CONSUMERCONTROL;
}

///////////////////////////////////////////////////////////////////////////////
void ConsumerControlMarshaller::tightUnmarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        BaseCommandMarshaller::tightUnmarshal( wireFormat, dataStructure, dataIn, bs );

        ConsumerControl* info =
            dynamic_cast<ConsumerControl*>( dataStructure );
        info->setClose( bs->readBoolean() );
        info->setConsumerId( Pointer<ConsumerId>( dynamic_cast< ConsumerId* >(
            tightUnmarshalNestedObject( wireFormat, dataIn, bs ) ) ) );
        info->setPrefetch( dataIn->readInt() );
        info->setFlush( bs->readBoolean() );
        info->setStart( bs->readBoolean() );
        info->setStop( bs->readBoolean() );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
int ConsumerControlMarshaller::tightMarshal1( OpenWireFormat* wireFormat, DataStructure* dataStructure, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        ConsumerControl* info =
            dynamic_cast<ConsumerControl*>( dataStructure );

        int rc = BaseCommandMarshaller::tightMarshal1( wireFormat, dataStructure, bs );
        bs->writeBoolean( info->isClose() );
        rc += tightMarshalNestedObject1( wireFormat, info->getConsumerId().get(), bs );
        bs->writeBoolean( info->isFlush() );
        bs->writeBoolean( info->isStart() );
        bs->writeBoolean( info->isStop() );

        return rc + 4;
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void ConsumerControlMarshaller::tightMarshal2( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        BaseCommandMarshaller::tightMarshal2( wireFormat, dataStructure, dataOut, bs );

        ConsumerControl* info =
            dynamic_cast<ConsumerControl*>( dataStructure );
        bs->readBoolean();
        tightMarshalNestedObject2( wireFormat, info->getConsumerId().get(), dataOut, bs );
        dataOut->writeInt( info->getPrefetch() );
        bs->readBoolean();
        bs->readBoolean();
        bs->readBoolean();
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void ConsumerControlMarshaller::looseUnmarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn ) throw( decaf::io::IOException ) {

    try {

        BaseCommandMarshaller::looseUnmarshal( wireFormat, dataStructure, dataIn );
        ConsumerControl* info =
            dynamic_cast<ConsumerControl*>( dataStructure );
        info->setClose( dataIn->readBoolean() );
        info->setConsumerId( Pointer<ConsumerId>( dynamic_cast< ConsumerId* >( 
            looseUnmarshalNestedObject( wireFormat, dataIn ) ) ) );
        info->setPrefetch( dataIn->readInt() );
        info->setFlush( dataIn->readBoolean() );
        info->setStart( dataIn->readBoolean() );
        info->setStop( dataIn->readBoolean() );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void ConsumerControlMarshaller::looseMarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut ) throw( decaf::io::IOException ) {

    try {

        ConsumerControl* info =
            dynamic_cast<ConsumerControl*>( dataStructure );
        BaseCommandMarshaller::looseMarshal( wireFormat, dataStructure, dataOut );

        dataOut->writeBoolean( info->isClose() );
        looseMarshalNestedObject( wireFormat, info->getConsumerId().get(), dataOut );
        dataOut->writeInt( info->getPrefetch() );
        dataOut->writeBoolean( info->isFlush() );
        dataOut->writeBoolean( info->isStart() );
        dataOut->writeBoolean( info->isStop() );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

