/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <activemq/wireformat/openwire/marshal/v4/XATransactionIdMarshaller.h>

#include <activemq/commands/XATransactionId.h>
#include <activemq/exceptions/ActiveMQException.h>
#include <decaf/lang/Pointer.h>

//
//     NOTE!: This file is autogenerated - do not modify!
//            if you need to make a change, please see the Java Classes in the
//            activemq-core module
//

using namespace std;
using namespace activemq;
using namespace activemq::exceptions;
using namespace activemq::commands;
using namespace activemq::wireformat;
using namespace activemq::wireformat::openwire;
using namespace activemq::wireformat::openwire::marshal;
using namespace activemq::wireformat::openwire::utils;
using namespace activemq::wireformat::openwire::marshal::v4;
using namespace decaf;
using namespace decaf::io;
using namespace decaf::lang;

///////////////////////////////////////////////////////////////////////////////
DataStructure* XATransactionIdMarshaller::createObject() const {
    return new XATransactionId();
}

///////////////////////////////////////////////////////////////////////////////
unsigned char XATransactionIdMarshaller::getDataStructureType() const {
    return XATransactionId::ID_XATRANSACTIONID;
}

///////////////////////////////////////////////////////////////////////////////
void XATransactionIdMarshaller::tightUnmarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        TransactionIdMarshaller::tightUnmarshal( wireFormat, dataStructure, dataIn, bs );

        XATransactionId* info =
            dynamic_cast<XATransactionId*>( dataStructure );
        info->setFormatId( dataIn->readInt() );
        info->setGlobalTransactionId( tightUnmarshalByteArray( dataIn, bs ) );
        info->setBranchQualifier( tightUnmarshalByteArray( dataIn, bs ) );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
int XATransactionIdMarshaller::tightMarshal1( OpenWireFormat* wireFormat, DataStructure* dataStructure, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        XATransactionId* info =
            dynamic_cast<XATransactionId*>( dataStructure );

        int rc = TransactionIdMarshaller::tightMarshal1( wireFormat, dataStructure, bs );
        bs->writeBoolean( info->getGlobalTransactionId().size() != 0 );
        rc += info->getGlobalTransactionId().size() == 0 ? 0 : (int)info->getGlobalTransactionId().size() + 4;
        bs->writeBoolean( info->getBranchQualifier().size() != 0 );
        rc += info->getBranchQualifier().size() == 0 ? 0 : (int)info->getBranchQualifier().size() + 4;

        return rc + 4;
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void XATransactionIdMarshaller::tightMarshal2( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        TransactionIdMarshaller::tightMarshal2( wireFormat, dataStructure, dataOut, bs );

        XATransactionId* info =
            dynamic_cast<XATransactionId*>( dataStructure );
        dataOut->writeInt( info->getFormatId() );
        if( bs->readBoolean() ) {
            dataOut->writeInt( (int)info->getGlobalTransactionId().size() );
            dataOut->write( (const unsigned char*)(&info->getGlobalTransactionId()[0]), (int)info->getGlobalTransactionId().size(), 0, (int)info->getGlobalTransactionId().size() );
        }
        if( bs->readBoolean() ) {
            dataOut->writeInt( (int)info->getBranchQualifier().size() );
            dataOut->write( (const unsigned char*)(&info->getBranchQualifier()[0]), (int)info->getBranchQualifier().size(), 0, (int)info->getBranchQualifier().size() );
        }
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void XATransactionIdMarshaller::looseUnmarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn ) throw( decaf::io::IOException ) {

    try {

        TransactionIdMarshaller::looseUnmarshal( wireFormat, dataStructure, dataIn );
        XATransactionId* info =
            dynamic_cast<XATransactionId*>( dataStructure );
        info->setFormatId( dataIn->readInt() );
        info->setGlobalTransactionId( looseUnmarshalByteArray( dataIn ) );
        info->setBranchQualifier( looseUnmarshalByteArray( dataIn ) );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void XATransactionIdMarshaller::looseMarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut ) throw( decaf::io::IOException ) {

    try {

        XATransactionId* info =
            dynamic_cast<XATransactionId*>( dataStructure );
        TransactionIdMarshaller::looseMarshal( wireFormat, dataStructure, dataOut );

        dataOut->writeInt( info->getFormatId() );
        dataOut->write( info->getGlobalTransactionId().size() != 0 );
        if( info->getGlobalTransactionId().size() != 0 ) {
            dataOut->writeInt( (int)info->getGlobalTransactionId().size() );
            dataOut->write( (const unsigned char*)(&info->getGlobalTransactionId()[0]), (int)info->getGlobalTransactionId().size(), 0, (int)info->getGlobalTransactionId().size() );
        }
        dataOut->write( info->getBranchQualifier().size() != 0 );
        if( info->getBranchQualifier().size() != 0 ) {
            dataOut->writeInt( (int)info->getBranchQualifier().size() );
            dataOut->write( (const unsigned char*)(&info->getBranchQualifier()[0]), (int)info->getBranchQualifier().size(), 0, (int)info->getBranchQualifier().size() );
        }
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

