/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.proxy;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.glite.security.util.proxy.ProxyPolicy;

public class ProxyCertInfoExtension
extends ASN1Encodable {
    public static final int UNLIMITED = Integer.MAX_VALUE;
    public static final String PROXY_CERT_INFO_EXTENSION_OID = "1.3.6.1.5.5.7.1.14";
    public static final String DRAFT_PROXY_CERT_INFO_EXTENSION_OID = "1.3.6.1.4.1.3536.1.1.222";
    private int m_pathLen = Integer.MAX_VALUE;
    private ProxyPolicy m_policy = null;

    public ProxyCertInfoExtension(int len, ProxyPolicy policy) {
        this.m_pathLen = len;
        this.m_policy = policy;
    }

    public ProxyCertInfoExtension() {
        this.m_policy = new ProxyPolicy("1.3.6.1.5.5.7.21.1");
    }

    public ProxyCertInfoExtension(byte[] bytes) throws IOException {
        this((ASN1Sequence)ASN1Object.fromByteArray((byte[])bytes));
    }

    public ProxyCertInfoExtension(ASN1Sequence seq) {
        int index = 0;
        if (seq != null && seq.size() > 0) {
            if (seq.getObjectAt(0) instanceof DERInteger) {
                this.m_pathLen = ((DERInteger)seq.getObjectAt(0)).getValue().intValue();
                index = 1;
            }
            if (seq.size() <= index) {
                throw new IllegalArgumentException("ProxyCertInfoExtension parser error, expected policy, but it was not found");
            }
            if (!(seq.getObjectAt(index) instanceof DERSequence)) {
                throw new IllegalArgumentException("ProxyCertInfoExtension parser error, expected policy sequence, but got: " + seq.getObjectAt(index).getClass());
            }
            this.m_policy = new ProxyPolicy((ASN1Sequence)seq.getObjectAt(index));
            if (seq.size() > ++index) {
                throw new IllegalArgumentException("ProxyCertInfoExtension parser error, sequence contains too many items");
            }
        }
    }

    public int getProxyPathLimit() {
        return this.m_pathLen;
    }

    public ProxyPolicy getPolicy() {
        return this.m_policy;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.m_pathLen > -1 && this.m_pathLen != Integer.MAX_VALUE) {
            v.add((DEREncodable)new DERInteger(this.m_pathLen));
        }
        if (this.m_policy == null) {
            throw new IllegalArgumentException("Can't generate ProxyCertInfoExtension without mandatory policy");
        }
        v.add((DEREncodable)this.m_policy.toASN1Object());
        return new DERSequence(v);
    }
}

