/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.glite.security.SecurityInfo;
import org.glite.security.util.CertUtil;
import org.glite.security.util.DN;
import org.glite.security.util.DNHandler;
import org.glite.security.util.X500Principal;

public class SecurityContext
extends Properties
implements SecurityInfo {
    private static final long serialVersionUID = -7396219279112154202L;
    private static final Logger LOGGER = Logger.getLogger(SecurityContext.class);
    private static ThreadLocal<SecurityContext> theSecurityContexts = new ThreadLocal();
    public static final String CERT_CHAIN = "org.glite.security.certchain";
    public static final String CLIENT_CERT = "org.glite.security.clientcert";
    public static final String CLIENT_NAME = "org.glite.security.clientname";
    public static final String CLIENT_DN = "org.glite.security.clientdn";
    public static final String CLIENT_X500_NAME = "org.glite.security.clientX500name";
    public static final String CLIENT_X500_PRINCIPAL = "org.glite.security.clientX500Principal";
    public static final String ISSUER_NAME = "org.glite.security.issuername";
    public static final String ISSUER_DN = "org.glite.security.issuerdn";
    public static final String UNVERIFIED_CERT_CHAIN = "org.glite.security.trustmanager.unverifiedchain";
    public static final String PEER_CAS = "org.glite.security.trustmanager.peercas";
    public static final String REMOTE_ADDR = "org.glite.security.trustmanager.remoteaddr";
    public static final String SESSION_ID = "org.glite.security.trustmanager.sessionid";

    public static SecurityContext getCurrentContext() {
        return theSecurityContexts.get();
    }

    public static void setCurrentContext(SecurityContext sc) {
        theSecurityContexts.set(sc);
    }

    public static void clearCurrentContext() {
        theSecurityContexts.set(null);
    }

    public void setClientCert(X509Certificate clientCert) {
        this.put(CLIENT_CERT, clientCert);
        DN issuerDN = DNHandler.getIssuer(clientCert);
        this.setIssuerDN(issuerDN);
        this.setIssuerName(issuerDN.getRFC2253());
        DN clientDN = DNHandler.getSubject(clientCert);
        this.setClientDN(clientDN);
        this.setClientName(clientDN.getRFC2253());
        this.setClientX500Name(clientDN.getX500());
        X500Principal principal = new X500Principal();
        principal.setName(clientDN);
        this.setClientX500Principal(principal);
    }

    public X509Certificate getClientCert() {
        return (X509Certificate)this.get(CLIENT_CERT);
    }

    public void setClientName(String clientName) {
        this.put(CLIENT_NAME, clientName);
    }

    public String getClientName() {
        return this.getProperty(CLIENT_NAME);
    }

    public void setClientDN(DN clientDN) {
        this.put(CLIENT_DN, clientDN);
    }

    public DN getClientDN() {
        return (DN)this.get(CLIENT_DN);
    }

    public void setClientX500Name(String clientName) {
        this.put(CLIENT_X500_NAME, clientName);
    }

    public String getClientX500Name() {
        return this.getProperty(CLIENT_X500_NAME);
    }

    public void setClientX500Principal(X500Principal clientPrincipal) {
        this.put(CLIENT_X500_PRINCIPAL, clientPrincipal);
    }

    public X500Principal getClientX500Principal() {
        return (X500Principal)this.get(CLIENT_X500_PRINCIPAL);
    }

    public void setIssuerName(String issuerName) {
        this.put(ISSUER_NAME, issuerName);
    }

    public String getIssuerName() {
        return this.getProperty(ISSUER_NAME);
    }

    public void setIssuerDN(DN issuerDN) {
        this.put(ISSUER_DN, issuerDN);
    }

    public DN getIssuerDN() {
        return (DN)this.get(ISSUER_DN);
    }

    public void setClientCertChain(X509Certificate[] certChain) {
        this.put(CERT_CHAIN, certChain);
        int i = CertUtil.findClientCert(certChain);
        if (i < 0) {
            LOGGER.warn((Object)"SecurityContext: No client certificate found in the supplied certificate chain");
            return;
        }
        this.setClientCert(certChain[i]);
    }

    public X509Certificate[] getClientCertChain() {
        return (X509Certificate[])this.get(CERT_CHAIN);
    }

    public void setUnverifiedCertChain(X509Certificate[] certChain) {
        this.put(UNVERIFIED_CERT_CHAIN, certChain);
    }

    public X509Certificate[] getUnverifiedCertChain() {
        return (X509Certificate[])this.get(UNVERIFIED_CERT_CHAIN);
    }

    public void setPeerCas(Principal[] principals) {
        this.put(PEER_CAS, principals);
    }

    public Principal[] getPeerCas() {
        return (Principal[])this.get(PEER_CAS);
    }

    public void setRemoteAddr(String remoteAddr) {
        this.put(REMOTE_ADDR, remoteAddr);
    }

    public String getRemoteAddr() {
        return this.getProperty(REMOTE_ADDR);
    }

    public void setSessionId(String sessionId) {
        this.put(SESSION_ID, sessionId);
    }

    public String getSessionId() {
        return this.getProperty(SESSION_ID);
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SecurityContext:\n");
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            sb.append("  " + entry.getKey() + " : " + entry.getValue() + "\n");
        }
        return sb.toString();
    }
}

