/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <activemq/wireformat/openwire/marshal/v4/DestinationInfoMarshaller.h>

#include <activemq/commands/DestinationInfo.h>
#include <activemq/exceptions/ActiveMQException.h>
#include <decaf/lang/Pointer.h>

//
//     NOTE!: This file is autogenerated - do not modify!
//            if you need to make a change, please see the Java Classes in the
//            activemq-core module
//

using namespace std;
using namespace activemq;
using namespace activemq::exceptions;
using namespace activemq::commands;
using namespace activemq::wireformat;
using namespace activemq::wireformat::openwire;
using namespace activemq::wireformat::openwire::marshal;
using namespace activemq::wireformat::openwire::utils;
using namespace activemq::wireformat::openwire::marshal::v4;
using namespace decaf;
using namespace decaf::io;
using namespace decaf::lang;

///////////////////////////////////////////////////////////////////////////////
DataStructure* DestinationInfoMarshaller::createObject() const {
    return new DestinationInfo();
}

///////////////////////////////////////////////////////////////////////////////
unsigned char DestinationInfoMarshaller::getDataStructureType() const {
    return DestinationInfo::ID_DESTINATIONINFO;
}

///////////////////////////////////////////////////////////////////////////////
void DestinationInfoMarshaller::tightUnmarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        BaseCommandMarshaller::tightUnmarshal( wireFormat, dataStructure, dataIn, bs );

        DestinationInfo* info =
            dynamic_cast<DestinationInfo*>( dataStructure );
        info->setConnectionId( Pointer<ConnectionId>( dynamic_cast< ConnectionId* >(
            tightUnmarshalCachedObject( wireFormat, dataIn, bs ) ) ) );
        info->setDestination( Pointer<ActiveMQDestination>( dynamic_cast< ActiveMQDestination* >(
            tightUnmarshalCachedObject( wireFormat, dataIn, bs ) ) ) );
        info->setOperationType( dataIn->readByte() );
        info->setTimeout( tightUnmarshalLong( wireFormat, dataIn, bs ) );

        if( bs->readBoolean() ) {
            short size = dataIn->readShort();
            info->getBrokerPath().reserve( size );
            for( int i = 0; i < size; i++ ) {
                info->getBrokerPath().push_back( Pointer<BrokerId>( dynamic_cast< BrokerId* >(
                    tightUnmarshalNestedObject( wireFormat, dataIn, bs ) ) ) );
            }
        }
        else {
            info->getBrokerPath().clear();
        }
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
int DestinationInfoMarshaller::tightMarshal1( OpenWireFormat* wireFormat, DataStructure* dataStructure, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        DestinationInfo* info =
            dynamic_cast<DestinationInfo*>( dataStructure );

        int rc = BaseCommandMarshaller::tightMarshal1( wireFormat, dataStructure, bs );
        rc += tightMarshalCachedObject1( wireFormat, info->getConnectionId().get(), bs );
        rc += tightMarshalCachedObject1( wireFormat, info->getDestination().get(), bs );
        rc += tightMarshalLong1( wireFormat, info->getTimeout(), bs );
        rc += tightMarshalObjectArray1( wireFormat, info->getBrokerPath(), bs );

        return rc + 1;
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void DestinationInfoMarshaller::tightMarshal2( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        BaseCommandMarshaller::tightMarshal2( wireFormat, dataStructure, dataOut, bs );

        DestinationInfo* info =
            dynamic_cast<DestinationInfo*>( dataStructure );
        tightMarshalCachedObject2( wireFormat, info->getConnectionId().get(), dataOut, bs );
        tightMarshalCachedObject2( wireFormat, info->getDestination().get(), dataOut, bs );
        dataOut->write( info->getOperationType() );
        tightMarshalLong2( wireFormat, info->getTimeout(), dataOut, bs );
        tightMarshalObjectArray2( wireFormat, info->getBrokerPath(), dataOut, bs );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void DestinationInfoMarshaller::looseUnmarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn ) throw( decaf::io::IOException ) {

    try {

        BaseCommandMarshaller::looseUnmarshal( wireFormat, dataStructure, dataIn );
        DestinationInfo* info =
            dynamic_cast<DestinationInfo*>( dataStructure );
        info->setConnectionId( Pointer<ConnectionId>( dynamic_cast< ConnectionId* >( 
            looseUnmarshalCachedObject( wireFormat, dataIn ) ) ) );
        info->setDestination( Pointer<ActiveMQDestination>( dynamic_cast< ActiveMQDestination* >( 
            looseUnmarshalCachedObject( wireFormat, dataIn ) ) ) );
        info->setOperationType( dataIn->readByte() );
        info->setTimeout( looseUnmarshalLong( wireFormat, dataIn ) );

        if( dataIn->readBoolean() ) {
            short size = dataIn->readShort();
            info->getBrokerPath().reserve( size );
            for( int i = 0; i < size; i++ ) {
                info->getBrokerPath().push_back( Pointer<BrokerId>( dynamic_cast<BrokerId* >(
                    looseUnmarshalNestedObject( wireFormat, dataIn ) ) ) );
            }
        }
        else {
            info->getBrokerPath().clear();
        }
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void DestinationInfoMarshaller::looseMarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut ) throw( decaf::io::IOException ) {

    try {

        DestinationInfo* info =
            dynamic_cast<DestinationInfo*>( dataStructure );
        BaseCommandMarshaller::looseMarshal( wireFormat, dataStructure, dataOut );

        looseMarshalCachedObject( wireFormat, info->getConnectionId().get(), dataOut );
        looseMarshalCachedObject( wireFormat, info->getDestination().get(), dataOut );
        dataOut->write( info->getOperationType() );
        looseMarshalLong( wireFormat, info->getTimeout(), dataOut );
        looseMarshalObjectArray( wireFormat, info->getBrokerPath(), dataOut );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

