/*
Copyright (c) Members of the EGEE Collaboration. 2004-2010.
See http://www.eu-egee.org/partners for details on the copyright holders.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include "InputChannel.H"
#include "ThreadPool.H"
#include "EventManager.H"

extern EventManager theEventManager;

void
InputChannel::start()
{
	ThreadPool::instance()->queueWorkRead(this);
}

void
InputChannel::onReady()
{
	Transport::Message *msg = NULL;
	int ret = m_transport->receive(m_connection, msg);
	if(ret <= 0) {
		// no new data read
	} else if(msg) {
		// we have a new message
		
	} else {
		// still need more data
		ThreadPool::instance()->queueWorkRead(this);
	}
}

void
InputChannel::onTimeout()
{
}

void
InputChannel::onError()
{
}
