/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.security.trustmanager.CRLCertChecker;
import org.glite.security.trustmanager.CRLFileTrustManager;
import org.glite.security.trustmanager.Log4jConfigurator;
import org.glite.security.trustmanager.OpensslTrustmanager;
import org.glite.security.trustmanager.OpensslTrustmanagerFactory;
import org.glite.security.trustmanager.SSLContextWrapper;
import org.glite.security.trustmanager.TimeoutSSLSocketFactory;
import org.glite.security.trustmanager.UpdatingKeyManager;
import org.glite.security.util.CaseInsensitiveProperties;
import org.glite.security.util.DNHandler;
import org.glite.security.util.FileCertReader;

public class ContextWrapper
implements SSLContextWrapper {
    static final Logger LOGGER = Logger.getLogger((String)ContextWrapper.class.getName());
    public static final String CREDENTIALS_PROXY_FILE = "gridProxyFile";
    public static final String CREDENTIALS_UPDATE_INTERVAL = "credentialsUpdateInterval";
    public static final String CREDENTIALS_CERT_FILE = "sslCertFile";
    public static final String CREDENTIALS_KEY_FILE = "sslKey";
    public static final String CREDENTIALS_KEY_PASSWD = "sslKeyPasswd";
    public static final String CREDENTIALS_STORE_FILE = "sslCertStore";
    public static final String CREDENTIALS_STORE_TYPE = "sslCertStoreType";
    public static final String CREDENTIALS_STORE_PASSWD = "sslCertStorePasswd";
    public static final String CA_FILES = "sslCAFiles";
    public static final String CA_STORE_FILE = "sslCAStore";
    public static final String CA_STORE_TYPE = "sslCAStoreType";
    public static final String CA_STORE_PASSWD = "sslCAStorePasswd";
    public static final String CRL_FILES = "crlFiles";
    public static final String CRL_ENABLED = "crlEnabled";
    public static final String CRL_REQUIRED = "crlRequired";
    public static final String CRL_UPDATE_INTERVAL = "crlUpdateInterval";
    public static final String LOG_CONF_FILE = "log4jConfFile";
    public static final String LOG_FILE = "logFile";
    public static final String SSL_PROTOCOL = "sslProtocol";
    public static final String CONF_FILE = "sslConfigFile";
    public static final String SSL_TIMEOUT_SETTING = "sslTimeout";
    public static final String CONNECT_TIMEOUT = "sslConnectTimeout";
    public static final String OVERRIDE_EXPIRATION_CHECK_ON_INIT = "internalOverrideExpirationCheck";
    public static final String GRID_PROXY_STREAM = "gridProxyStream";
    public static final String KEYSTORE_TYPE_DEFAULT = "JKS";
    public static final String CRL_UPDATE_INTERVAL_DEFAULT = "0";
    public static final String CRL_REQUIRED_DEFAULT = "true";
    public static final String SSL_PROTOCOL_DEFAULT = "TLSv1";
    public static final String CRL_ENABLED_DEFAULT = "true";
    public static final String CREDENTIALS_UPDATE_INTERVAL_DEAFULT = "0 s";
    public static final String CA_FILES_DEFAULT = "/etc/grid-security/certificates/*.0";
    public static final String CRL_FILES_DEFAULT = "/etc/grid-security/certificates/*.r0";
    public static final String TIMEOUT_DEFAULT = "60000";
    public static final String INT_KEYSTORE_PASSWD = "internal";
    public static final String TRUSTSTORE_DIR = "trustStoreDir";
    public static final String TRUSTSTORE_DIR_DEFAULT = "/etc/grid-security/certificates";
    public static final String HOSTNAME_CHECK = "hostnameCheck";
    public static final String WANT_LOG4J_SETUP = "wantLog4jSetup";
    public static final String WANT_LOG4J_SETUP_DEFAULT = "true";
    public static final String HOSTNAME_CHECK_DEFAULT = "true";
    private static boolean s_loggerConfigured = false;
    public CaseInsensitiveProperties config;
    public KeyManager[] identityKeyManagers = null;
    public Vector trustAnchors = null;
    public Vector crls = null;
    public FileCertReader certReader = null;
    public CRLFileTrustManager trustManager = null;
    public OpensslTrustmanager m_trustmanager = null;
    public boolean overrideExpirationCheck = false;
    Timer crlTimer = null;
    SSLContext sslContext;
    SSLServerSocketFactory serverSocketFactory = null;
    SSLSocketFactory socketFactory = null;

    public ContextWrapper(Properties inputConfig, boolean wantLog4jConf) throws IOException, GeneralSecurityException {
        this.loadConfig(inputConfig, wantLog4jConf);
        this.init(null, null, null);
    }

    public ContextWrapper(Properties inputConfig) throws IOException, GeneralSecurityException {
        this.loadConfig(inputConfig, true);
        this.init(null, null, null);
    }

    public ContextWrapper(Properties inputConfig, X509Certificate[] chain, PrivateKey key) throws IOException, GeneralSecurityException {
        this.loadConfig(inputConfig, true);
        this.init(null, chain, key);
    }

    public ContextWrapper(Properties inputConfig, PasswordFinder finder) throws IOException, GeneralSecurityException {
        this.loadConfig(inputConfig, true);
        this.init(finder, null, null);
    }

    public void loadConfig(Properties inputConfig, boolean wantLog4jConfiguration) throws FileNotFoundException, IOException {
        String confFile = inputConfig.getProperty(CONF_FILE);
        if (confFile != null) {
            this.config = new CaseInsensitiveProperties();
            this.config.load(new FileInputStream(confFile));
        } else {
            this.config = new CaseInsensitiveProperties(inputConfig);
        }
        if (this.config.getProperty(OVERRIDE_EXPIRATION_CHECK_ON_INIT) != null) {
            this.overrideExpirationCheck = true;
        }
        String wantLog4jSetup = this.config.getProperty(WANT_LOG4J_SETUP, "true").trim().toLowerCase();
        boolean withLog4jSetup = true;
        if (wantLog4jSetup.startsWith("n") || wantLog4jSetup.startsWith("f")) {
            withLog4jSetup = false;
        }
        if (!s_loggerConfigured && wantLog4jConfiguration && withLog4jSetup) {
            String logConf = this.config.getProperty(LOG_CONF_FILE);
            String logFile = this.config.getProperty(LOG_FILE);
            Log4jConfigurator.configure(logConf, logFile);
        }
    }

    public SSLContext getContext() {
        return this.sslContext;
    }

    public SSLServerSocketFactory getServerSocketFactory() throws SSLException {
        if (this.socketFactory != null) {
            LOGGER.fatal((Object)"Trying to use a client-use ContextWrapper to create server socket factory");
            throw new SSLException("Trying to use a client-use ContextWrapper to create server socket factory");
        }
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = this.sslContext.getServerSocketFactory();
        }
        return this.serverSocketFactory;
    }

    public SSLSocketFactory getSocketFactory() throws SSLException {
        if (this.serverSocketFactory != null) {
            LOGGER.fatal((Object)"Trying to use a server-use ContextWrapper to create client socket factory");
            throw new SSLException("Trying to use a server-use ContextWrapper to create client socket factory");
        }
        if (this.socketFactory == null) {
            this.socketFactory = new TimeoutSSLSocketFactory(this.sslContext.getSocketFactory(), this.config);
        }
        return this.socketFactory;
    }

    public void init(PasswordFinder finder, X509Certificate[] chain, PrivateKey key) throws CertificateException, GeneralSecurityException, IOException {
        this.certReader = new FileCertReader();
        try {
            TrustManager[] managerArray;
            if (chain == null && key == null) {
                this.initKeyManagers(finder);
            } else {
                if (chain == null || key == null) {
                    LOGGER.fatal((Object)"Internal error: either certificate chain or private key of credentials is not defined");
                    throw new CertificateException("Internal error: either certificate chain or private key of credentials is not defined");
                }
                this.initKeyManagers(chain, key);
            }
            String CAFiles = this.config.getProperty(CA_FILES);
            LOGGER.debug((Object)("sslCAFiles is " + CAFiles));
            if (CAFiles != null) {
                LOGGER.debug((Object)("old way with sslCAFiles=" + CAFiles));
                this.initTrustAnchors();
                this.trustManager = new CRLFileTrustManager(this.trustAnchors);
                managerArray = new TrustManager[]{this.trustManager};
            } else {
                String trustDir = this.config.getProperty(TRUSTSTORE_DIR, TRUSTSTORE_DIR_DEFAULT);
                String crlRequired = this.config.getProperty(CRL_REQUIRED, "true");
                crlRequired = crlRequired.trim().toLowerCase();
                LOGGER.debug((Object)("new way with trust dir: " + trustDir));
                this.m_trustmanager = crlRequired.startsWith("f") || crlRequired.startsWith("n") ? OpensslTrustmanagerFactory.getTrustmanager(null, trustDir, false, this.config) : OpensslTrustmanagerFactory.getTrustmanager(null, trustDir, true, this.config);
                managerArray = new TrustManager[]{this.m_trustmanager};
            }
            String protocol = this.config.getProperty(SSL_PROTOCOL, SSL_PROTOCOL_DEFAULT);
            LOGGER.debug((Object)("Using transport protocol: " + protocol));
            this.sslContext = SSLContext.getInstance(protocol);
            LOGGER.debug((Object)("Actually using transport protocol: " + this.sslContext.getProtocol()));
            this.sslContext.init(this.identityKeyManagers, managerArray, new SecureRandom());
            this.startCRLLoop();
        }
        catch (GeneralSecurityException e) {
            LOGGER.fatal((Object)("ContextWrapper initialization failed: " + e.getMessage()));
            throw e;
        }
        catch (IOException e) {
            LOGGER.fatal((Object)("ContextWrapper initialization failed: " + e.getMessage()));
            throw e;
        }
        catch (ParseException e) {
            LOGGER.fatal((Object)("ContextWrapper initialization failed: " + e.getMessage()));
            throw new IOException("ContextWrapper initialization failed: " + e.getMessage());
        }
    }

    public void initKeyManagers(PasswordFinder finder) throws CertificateException, NoSuchAlgorithmException {
        try {
            LOGGER.debug((Object)"ContextHandler.initKeyManagers");
            UpdatingKeyManager updatingKeyManager = new UpdatingKeyManager(this.config, finder);
            this.identityKeyManagers = new KeyManager[]{updatingKeyManager};
            String[] aliases = updatingKeyManager.getClientAliases("RSA", null);
            if (aliases == null || aliases.length == 0) {
                aliases = updatingKeyManager.getServerAliases("RSA", null);
            }
            if (aliases == null || aliases.length == 0) {
                throw new CertificateException("No credentials found");
            }
            X509Certificate[] chain = updatingKeyManager.getCertificateChain(aliases[0]);
            if (!this.overrideExpirationCheck) {
                for (int n = 0; n < chain.length; ++n) {
                    try {
                        chain[n].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException e) {
                        throw new CertificateExpiredException("Certificate for " + DNHandler.getSubject(chain[n]).getRFCDN() + ", cert file was " + updatingKeyManager.m_credentialFile + ": " + e.getMessage());
                    }
                    catch (CertificateNotYetValidException e) {
                        throw new CertificateNotYetValidException("Certificate for " + DNHandler.getSubject(chain[n]).getRFCDN() + ", cert file was " + updatingKeyManager.m_credentialFile + ": " + e.getMessage());
                    }
                }
            }
        }
        catch (CertificateException e) {
            LOGGER.fatal((Object)("The credentials reading failed:  " + e.getMessage()));
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.fatal((Object)("Internal error: while reading credentials " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public void initKeyManagers(X509Certificate[] chain, PrivateKey key) throws CertificateException, NoSuchAlgorithmException, IOException {
        try {
            if (!this.overrideExpirationCheck) {
                for (int n = 0; n < chain.length; ++n) {
                    chain[n].checkValidity();
                }
            }
            LOGGER.debug((Object)"ContextHandler.initKeyManagers(chain, key)");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            KeyStore store = KeyStore.getInstance(KEYSTORE_TYPE_DEFAULT);
            store.load(null, null);
            store.setKeyEntry("identity", key, INT_KEYSTORE_PASSWD.toCharArray(), chain);
            keyManagerFactory.init(store, INT_KEYSTORE_PASSWD.toCharArray());
            this.identityKeyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (CertificateException e) {
            LOGGER.fatal((Object)("The credentials creation from given cert chain and private key failed:  " + e.getMessage()));
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.fatal((Object)("The credentials creation from given cert chain and private key failed:  " + e.getMessage()));
            throw e;
        }
        catch (IOException e) {
            LOGGER.fatal((Object)("The credentials loading from given cert chain and private key failed:  " + e.getMessage()));
            throw e;
        }
        catch (KeyStoreException e) {
            LOGGER.fatal((Object)("The keystore creation from given cert chain and private key failed:  " + e.getMessage()));
            throw new CertificateException(e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            LOGGER.fatal((Object)("Internal error while loading credentials:  " + e.getMessage()));
            throw new CertificateException(e.getMessage());
        }
    }

    void initTrustAnchors() throws KeyStoreException, IOException, CertificateException {
        FileInputStream caStoreStream = null;
        try {
            String caStoreFile = this.config.getProperty(CA_STORE_FILE);
            if (caStoreFile != null) {
                String caStoreType = this.config.getProperty(CA_STORE_TYPE, KEYSTORE_TYPE_DEFAULT);
                String caStorePasswd = this.config.getProperty(CA_STORE_PASSWD);
                KeyStore caStore = KeyStore.getInstance(caStoreType);
                caStoreStream = new FileInputStream(caStoreFile);
                caStore.load(caStoreStream, caStorePasswd.toCharArray());
                Enumeration<String> aliases = caStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate cert = (X509Certificate)caStore.getCertificate(aliases.nextElement());
                    this.trustAnchors.add(new TrustAnchor(cert, null));
                }
                if (this.trustAnchors.size() == 0) {
                    throw new IOException("No CA store file found matching \"" + caStore);
                }
            } else {
                String caFiles = this.config.getProperty(CA_FILES, CA_FILES_DEFAULT);
                this.trustAnchors = this.certReader.readAnchors(caFiles);
                if (this.trustAnchors.size() == 0) {
                    throw new IOException("No CA files found matching \"" + caFiles);
                }
            }
        }
        catch (KeyStoreException e) {
            LOGGER.fatal((Object)("The trusted certificate authority certificates reading failed:  " + e.getMessage()));
            throw new KeyStoreException("The trusted certificate authority certificates reading failed:  " + e.toString());
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.fatal((Object)("The trusted certificate authority certificates reading failed:  " + e.getMessage()));
            throw new CertificateException("The trusted certificate authority certificates reading failed:  " + e.toString());
        }
        catch (IOException e) {
            LOGGER.fatal((Object)("The trusted certificate authority certificates reading failed:  " + e.getMessage()));
            throw new IOException("The trusted certificate authority certificates reading failed:  " + e.toString());
        }
        catch (CertificateException e) {
            LOGGER.fatal((Object)("The trusted certificate authority certificates reading failed:  " + e.getMessage()));
            throw e;
        }
        finally {
            if (caStoreStream != null) {
                caStoreStream.close();
            }
        }
    }

    void startCRLLoop() throws CertificateException, IOException, ParseException {
        String crlEnabled;
        if (this.trustManager != null && (crlEnabled = this.config.getProperty(CRL_ENABLED, "true")).toLowerCase().startsWith("f")) {
            return;
        }
        if (this.crlTimer != null) {
            return;
        }
        if (this.updateCRLs()) {
            String interval = this.config.getProperty(CRL_UPDATE_INTERVAL, CRL_UPDATE_INTERVAL_DEFAULT);
            long intervalSecs = ContextWrapper.getIntervalSecs(interval);
            if (intervalSecs < 1L) {
                LOGGER.debug((Object)("The CRL update interval is less than 1 second, update loop not started. Value was: " + intervalSecs));
                return;
            }
            this.crlTimer = new Timer(true);
            this.crlTimer.schedule((TimerTask)new RefreshCRLs(), intervalSecs * 1000L, intervalSecs * 1000L);
        }
    }

    boolean updateCRLs() throws CertificateException, IOException, ParseException {
        if (this.trustManager == null && this.m_trustmanager == null) {
            LOGGER.fatal((Object)"Trying to set CRLs in uninitialized ContextWrapper");
            throw new SecurityException("Trying to set CRLs in uninitialized ContextWrapper");
        }
        if (this.m_trustmanager != null) {
            this.m_trustmanager.checkUpdate();
            return true;
        }
        String crlFiles = this.config.getProperty(CRL_FILES, CRL_FILES_DEFAULT);
        if (crlFiles == null) {
            return false;
        }
        try {
            Vector allCRLs = this.certReader.readCRLs(crlFiles);
            Vector acceptedCRLs = this.checkCRLs(allCRLs);
            if (!acceptedCRLs.isEmpty()) {
                String crlRequired = this.config.getProperty(CRL_REQUIRED, "true");
                boolean required = false;
                if (crlRequired.toLowerCase().startsWith("t")) {
                    required = true;
                }
                CRLCertChecker checker = new CRLCertChecker(acceptedCRLs, required);
                this.trustManager.setChecker(checker);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            LOGGER.fatal((Object)("Error while setting CRLs. Tried to read " + crlFiles + " with current path " + System.getProperty("user.dir") + " error was " + e.toString()));
            throw new IOException("Error while setting CRLs. Tried to read " + crlFiles + " with current path " + System.getProperty("user.dir") + " error was " + e.toString());
        }
        catch (CertificateException e) {
            LOGGER.fatal((Object)("Error while setting CRLs. Tried to read " + crlFiles + " with current path " + System.getProperty("user.dir") + " error was " + e.toString()));
            throw new CertificateException("Error while setting CRLs. Tried to read " + crlFiles + " with current path " + System.getProperty("user.dir") + " error was " + e.toString());
        }
    }

    Vector checkCRLs(Vector uncheked) throws SecurityException {
        if (this.trustAnchors == null) {
            LOGGER.fatal((Object)"Trying to check CRLs without setting trustanchors first");
            throw new SecurityException("Trying to check CRLs without setting trustanchors first");
        }
        Iterator crlIter = uncheked.iterator();
        while (crlIter.hasNext()) {
            X509CRL crl = (X509CRL)crlIter.next();
            Iterator caIter = this.trustAnchors.iterator();
            boolean cheked = false;
            while (caIter.hasNext()) {
                TrustAnchor anchor = (TrustAnchor)caIter.next();
                X509Certificate caCert = anchor.getTrustedCert();
                if (!((Object)caCert.getSubjectDN()).equals(crl.getIssuerDN())) continue;
                try {
                    crl.verify(caCert.getPublicKey());
                    cheked = true;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Invalid signature in CRL from " + ((Object)crl.getIssuerDN()).toString()));
                }
                break;
            }
            if (cheked) continue;
            LOGGER.error((Object)("Rejecting a CRL from " + ((Object)crl.getIssuerDN()).toString() + " because corresponding ca not found or invalid signature"));
            crlIter.remove();
        }
        return uncheked;
    }

    public static long getIntervalSecs(String intervalBlob) {
        long number;
        int n;
        for (n = 0; n < intervalBlob.length() && Character.isDigit(intervalBlob.charAt(n)); ++n) {
        }
        if (n == 0) {
            number = 1L;
        } else {
            String numberString = intervalBlob.substring(0, n);
            number = Long.parseLong(numberString);
            if (number == 0L) {
                return 0L;
            }
        }
        String unit = intervalBlob.substring(n).toLowerCase().trim();
        if (unit.charAt(0) == 's') {
            return number;
        }
        if (unit.charAt(0) == 'm') {
            return number * 60L;
        }
        if (unit.charAt(0) == 'h') {
            return number * 60L * 60L;
        }
        if (unit.charAt(0) == 'd') {
            return number * 24L * 60L * 60L;
        }
        LOGGER.fatal((Object)("invalid time unit definition in \"" + intervalBlob + "\" should start either with s, m, h or d"));
        throw new IllegalArgumentException("invalid unit definition in \"" + intervalBlob + "\" should start either with s, m, h or d");
    }

    public X509KeyManager getKeyManager() {
        return (X509KeyManager)this.identityKeyManagers[0];
    }

    public void stop() {
        if (this.crlTimer != null) {
            this.crlTimer.cancel();
            this.crlTimer = null;
        }
        if (this.identityKeyManagers != null && this.identityKeyManagers[0] != null && this.identityKeyManagers[0] instanceof UpdatingKeyManager) {
            ((UpdatingKeyManager)this.identityKeyManagers[0]).stop();
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            LOGGER.debug((Object)"ContextWrapper: bouncycastle provider set.");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    class RefreshCRLs
    extends TimerTask {
        RefreshCRLs() {
        }

        public void run() {
            LOGGER.debug((Object)"refreshing CRLs.\n");
            try {
                ContextWrapper.this.updateCRLs();
            }
            catch (Exception e) {
                LOGGER.fatal((Object)"The CRL updating failed");
            }
        }
    }
}

