/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.namespace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.glite.security.util.DNHandler;
import org.glite.security.util.namespace.NamespaceFormat;
import org.glite.security.util.namespace.NamespacePolicy;

public class LegacyNamespaceFormat
extends NamespaceFormat {
    private static final Logger LOGGER = Logger.getLogger(LegacyNamespaceFormat.class);
    private static final String ACCESS_ID_CA = "access_id_ca";
    private static final String POS_RIGHTS = "pos_rights";
    private static final String COND_SUBJECTS = "cond_subjects";
    private String m_issuer = null;
    private String m_accessRights = null;
    private Subject[] m_subjects = null;

    public void parse(String filename) throws IOException, ParseException {
        File file = new File(filename);
        BufferedReader reader = null;
        this.m_issuer = null;
        this.m_accessRights = null;
        this.m_subjects = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                ++lineNumber;
                if (line.startsWith("#") || line.length() <= 0) continue;
                this.addPolicy(line, lineNumber, filename);
            }
            if (this.m_issuer == null) {
                throw new ParseException("No issuer found in the signign policy in file: " + filename + ".", 0);
            }
            if (this.m_accessRights == null) {
                throw new ParseException("No rights definition found in the signign policy in file: " + filename + ".", 0);
            }
            if (this.m_subjects == null) {
                throw new ParseException("No subject definition found in the signign policy in file: " + filename + ".", 0);
            }
            for (Subject subject : this.m_subjects) {
                if (subject.m_subject.trim().length() <= 0) continue;
                NamespacePolicy policy = new NamespacePolicy(DNHandler.getDNRFC2253(this.m_issuer), this.m_accessRights, subject.m_subject, subject.m_statement, subject.m_lineNumber, subject.m_filename);
                this.getPolices().add(policy);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParseException e) {
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void addPolicy(String inputStatement, int lineNumber, String filename) throws ParseException {
        String statement = inputStatement.toLowerCase().trim();
        if (statement.contains(ACCESS_ID_CA)) {
            String[] split = (statement = statement.trim()).split("access_id_ca\\s+x509\\s+");
            if (split.length < 2) {
                LOGGER.debug((Object)("access_id_castatement \"" + statement + "\" doesnt contain x509 field or value."));
                throw new ParseException("access_id_ca line is missing x509 field or value field.", lineNumber);
            }
            this.m_issuer = split[1].replace("'", "").replace("\"", "").trim();
        } else if (statement.contains(POS_RIGHTS)) {
            String[] split = statement.split("pos_rights\\s+globus\\s+");
            if (split.length < 2) {
                LOGGER.debug((Object)("pos_rightsstatement \"" + statement + "\" doesnt contain globus field or value."));
                throw new ParseException("pos_rights line is missing globus field or value field.", lineNumber);
            }
            this.m_accessRights = split[1].replace("'", "").replace("\"", "").trim();
        } else if (statement.contains(COND_SUBJECTS)) {
            String[] split = statement.split("cond_subjects\\s+globus");
            if (split.length < 2) {
                LOGGER.debug((Object)("cond_subjectsstatement \"" + statement + "\" doesnt contain globus field or value."));
                throw new ParseException("cond_subjects line is missing globus field or value field.", lineNumber);
            }
            String[] subjects = split[1].split("[']|[\"]");
            Vector<Subject> subjectsVect = new Vector<Subject>();
            for (String subject : subjects) {
                if (subject.trim().length() <= 0) continue;
                subjectsVect.add(new Subject(subject, statement, lineNumber, filename));
            }
            this.m_subjects = subjectsVect.toArray(new Subject[0]);
        } else if (!statement.equals("")) {
            throw new ParseException("Unrecognized policy line: " + statement, lineNumber);
        }
    }

    private class Subject {
        String m_subject;
        String m_statement;
        int m_lineNumber;
        String m_filename;

        public Subject(String subject, String statement, int lineNum, String filename) {
            this.m_subject = subject;
            this.m_statement = statement;
            this.m_lineNumber = lineNum;
            this.m_filename = filename;
        }
    }
}

