/* soapC.c
   Generated by gSOAP 2.7.9k from VOMSAC.h
   Copyright(C) 2000-2007, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.9k 2009-02-24 13:26:03 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header));
		soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_ns1__StatusType:
		return soap_in_ns1__StatusType(soap, NULL, NULL, "ns1:StatusType");
	case SOAP_TYPE_ns1__StatusCodeType:
		return soap_in_ns1__StatusCodeType(soap, NULL, NULL, "ns1:StatusCodeType");
	case SOAP_TYPE_PointerTo_ns1__GetAttributeCertificateResponse:
		return soap_in_PointerTo_ns1__GetAttributeCertificateResponse(soap, NULL, NULL, "ns1:GetAttributeCertificateResponse");
	case SOAP_TYPE_PointerTo_ns1__GetAttributeCertificate:
		return soap_in_PointerTo_ns1__GetAttributeCertificate(soap, NULL, NULL, "ns1:GetAttributeCertificate");
	case SOAP_TYPE_PointerTons1__StatusType:
		return soap_in_PointerTons1__StatusType(soap, NULL, NULL, "ns1:StatusType");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTons1__StatusCodeType:
		return soap_in_PointerTons1__StatusCodeType(soap, NULL, NULL, "ns1:StatusCodeType");
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:StatusType"))
		{	*type = SOAP_TYPE_ns1__StatusType;
			return soap_in_ns1__StatusType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:StatusCodeType"))
		{	*type = SOAP_TYPE_ns1__StatusCodeType;
			return soap_in_ns1__StatusCodeType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "ns1:GetAttributeCertificateResponse"))
		{	*type = SOAP_TYPE__ns1__GetAttributeCertificateResponse;
			return soap_in__ns1__GetAttributeCertificateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:GetAttributeCertificate"))
		{	*type = SOAP_TYPE__ns1__GetAttributeCertificate;
			return soap_in__ns1__GetAttributeCertificate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE__ns1__GetAttributeCertificateResponse:
		return soap_out__ns1__GetAttributeCertificateResponse(soap, "ns1:GetAttributeCertificateResponse", id, (const struct _ns1__GetAttributeCertificateResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__GetAttributeCertificate:
		return soap_out__ns1__GetAttributeCertificate(soap, "ns1:GetAttributeCertificate", id, (const struct _ns1__GetAttributeCertificate *)ptr, NULL);
	case SOAP_TYPE_ns1__StatusType:
		return soap_out_ns1__StatusType(soap, tag, id, (const struct ns1__StatusType *)ptr, "ns1:StatusType");
	case SOAP_TYPE_ns1__StatusCodeType:
		return soap_out_ns1__StatusCodeType(soap, tag, id, (const struct ns1__StatusCodeType *)ptr, "ns1:StatusCodeType");
	case SOAP_TYPE_PointerTo_ns1__GetAttributeCertificateResponse:
		return soap_out_PointerTo_ns1__GetAttributeCertificateResponse(soap, tag, id, (struct _ns1__GetAttributeCertificateResponse *const*)ptr, "ns1:GetAttributeCertificateResponse");
	case SOAP_TYPE_PointerTo_ns1__GetAttributeCertificate:
		return soap_out_PointerTo_ns1__GetAttributeCertificate(soap, tag, id, (struct _ns1__GetAttributeCertificate *const*)ptr, "ns1:GetAttributeCertificate");
	case SOAP_TYPE_PointerTons1__StatusType:
		return soap_out_PointerTons1__StatusType(soap, tag, id, (struct ns1__StatusType *const*)ptr, "ns1:StatusType");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTons1__StatusCodeType:
		return soap_out_PointerTons1__StatusCodeType(soap, tag, id, (struct ns1__StatusCodeType *const*)ptr, "ns1:StatusCodeType");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:anyURI");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "xsd:QName", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE___ns1__GetAttributeCertificate:
		soap_serialize___ns1__GetAttributeCertificate(soap, (const struct __ns1__GetAttributeCertificate *)ptr);
		break;
	case SOAP_TYPE__ns1__GetAttributeCertificateResponse:
		soap_serialize__ns1__GetAttributeCertificateResponse(soap, (const struct _ns1__GetAttributeCertificateResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__GetAttributeCertificate:
		soap_serialize__ns1__GetAttributeCertificate(soap, (const struct _ns1__GetAttributeCertificate *)ptr);
		break;
	case SOAP_TYPE_ns1__StatusType:
		soap_serialize_ns1__StatusType(soap, (const struct ns1__StatusType *)ptr);
		break;
	case SOAP_TYPE_ns1__StatusCodeType:
		soap_serialize_ns1__StatusCodeType(soap, (const struct ns1__StatusCodeType *)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__GetAttributeCertificateResponse:
		soap_serialize_PointerTo_ns1__GetAttributeCertificateResponse(soap, (struct _ns1__GetAttributeCertificateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__GetAttributeCertificate:
		soap_serialize_PointerTo_ns1__GetAttributeCertificate(soap, (struct _ns1__GetAttributeCertificate *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__StatusType:
		soap_serialize_PointerTons1__StatusType(soap, (struct ns1__StatusType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__StatusCodeType:
		soap_serialize_PointerTons1__StatusCodeType(soap, (struct ns1__StatusCodeType *const*)ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__GetAttributeCertificate(struct soap *soap, struct __ns1__GetAttributeCertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__GetAttributeCertificate = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__GetAttributeCertificate(struct soap *soap, const struct __ns1__GetAttributeCertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__GetAttributeCertificate(soap, &a->ns1__GetAttributeCertificate);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__GetAttributeCertificate(struct soap *soap, const struct __ns1__GetAttributeCertificate *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__GetAttributeCertificate(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__GetAttributeCertificate(struct soap *soap, const char *tag, int id, const struct __ns1__GetAttributeCertificate *a, const char *type)
{
	soap_out_PointerTo_ns1__GetAttributeCertificate(soap, "ns1:GetAttributeCertificate", -1, &a->ns1__GetAttributeCertificate, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__GetAttributeCertificate * SOAP_FMAC4 soap_get___ns1__GetAttributeCertificate(struct soap *soap, struct __ns1__GetAttributeCertificate *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__GetAttributeCertificate(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__GetAttributeCertificate * SOAP_FMAC4 soap_in___ns1__GetAttributeCertificate(struct soap *soap, const char *tag, struct __ns1__GetAttributeCertificate *a, const char *type)
{
	short soap_flag_ns1__GetAttributeCertificate = 1;
	short soap_flag;
	a = (struct __ns1__GetAttributeCertificate *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__GetAttributeCertificate, sizeof(struct __ns1__GetAttributeCertificate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__GetAttributeCertificate(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__GetAttributeCertificate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__GetAttributeCertificate(soap, "ns1:GetAttributeCertificate", &a->ns1__GetAttributeCertificate, ""))
				{	soap_flag_ns1__GetAttributeCertificate--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__GetAttributeCertificateResponse(struct soap *soap, struct _ns1__GetAttributeCertificateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->Status = NULL;
	soap_default_string(soap, &a->AttributeCertificate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__GetAttributeCertificateResponse(struct soap *soap, const struct _ns1__GetAttributeCertificateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__StatusType(soap, &a->Status);
	soap_serialize_string(soap, &a->AttributeCertificate);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__GetAttributeCertificateResponse(struct soap *soap, const struct _ns1__GetAttributeCertificateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__GetAttributeCertificateResponse);
	if (soap_out__ns1__GetAttributeCertificateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__GetAttributeCertificateResponse(struct soap *soap, const char *tag, int id, const struct _ns1__GetAttributeCertificateResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__GetAttributeCertificateResponse), type);
	soap_out_PointerTons1__StatusType(soap, "Status", -1, &a->Status, "");
	soap_out_string(soap, "AttributeCertificate", -1, &a->AttributeCertificate, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__GetAttributeCertificateResponse * SOAP_FMAC4 soap_get__ns1__GetAttributeCertificateResponse(struct soap *soap, struct _ns1__GetAttributeCertificateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__GetAttributeCertificateResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__GetAttributeCertificateResponse * SOAP_FMAC4 soap_in__ns1__GetAttributeCertificateResponse(struct soap *soap, const char *tag, struct _ns1__GetAttributeCertificateResponse *a, const char *type)
{
	short soap_flag_Status = 1, soap_flag_AttributeCertificate = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__GetAttributeCertificateResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__GetAttributeCertificateResponse, sizeof(struct _ns1__GetAttributeCertificateResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__GetAttributeCertificateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Status && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__StatusType(soap, "Status", &a->Status, "ns1:StatusType"))
				{	soap_flag_Status--;
					continue;
				}
			if (soap_flag_AttributeCertificate && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "AttributeCertificate", &a->AttributeCertificate, "xsd:string"))
				{	soap_flag_AttributeCertificate--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__GetAttributeCertificateResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__GetAttributeCertificateResponse, 0, sizeof(struct _ns1__GetAttributeCertificateResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Status > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__GetAttributeCertificate(struct soap *soap, struct _ns1__GetAttributeCertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeFQAN = 0;
	a->ns1__FQAN = NULL;
	a->__sizeTarget = 0;
	a->ns1__Target = NULL;
	a->ns1__Lifetime = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__GetAttributeCertificate(struct soap *soap, const struct _ns1__GetAttributeCertificate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->ns1__FQAN)
	{	int i;
		for (i = 0; i < a->__sizeFQAN; i++)
		{
			soap_serialize_string(soap, a->ns1__FQAN + i);
		}
	}
	if (a->ns1__Target)
	{	int i;
		for (i = 0; i < a->__sizeTarget; i++)
		{
			soap_serialize_string(soap, a->ns1__Target + i);
		}
	}
	soap_serialize_PointerToint(soap, &a->ns1__Lifetime);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__GetAttributeCertificate(struct soap *soap, const struct _ns1__GetAttributeCertificate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__GetAttributeCertificate);
	if (soap_out__ns1__GetAttributeCertificate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__GetAttributeCertificate(struct soap *soap, const char *tag, int id, const struct _ns1__GetAttributeCertificate *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__GetAttributeCertificate), type);
	if (a->ns1__FQAN)
	{	int i;
		for (i = 0; i < a->__sizeFQAN; i++)
			soap_out_string(soap, "ns1:FQAN", -1, a->ns1__FQAN + i, "");
	}
	if (a->ns1__Target)
	{	int i;
		for (i = 0; i < a->__sizeTarget; i++)
			soap_out_string(soap, "ns1:Target", -1, a->ns1__Target + i, "");
	}
	soap_out_PointerToint(soap, "ns1:Lifetime", -1, &a->ns1__Lifetime, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__GetAttributeCertificate * SOAP_FMAC4 soap_get__ns1__GetAttributeCertificate(struct soap *soap, struct _ns1__GetAttributeCertificate *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__GetAttributeCertificate(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__GetAttributeCertificate * SOAP_FMAC4 soap_in__ns1__GetAttributeCertificate(struct soap *soap, const char *tag, struct _ns1__GetAttributeCertificate *a, const char *type)
{
	short soap_flag_ns1__FQAN = 1, soap_flag_ns1__Target = 1, soap_flag_ns1__Lifetime = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__GetAttributeCertificate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__GetAttributeCertificate, sizeof(struct _ns1__GetAttributeCertificate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__GetAttributeCertificate(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__FQAN && soap->error == SOAP_TAG_MISMATCH)
			{	char **p;
				soap_new_block(soap);
				for (a->__sizeFQAN = 0; !soap_element_begin_in(soap, "ns1:FQAN", 1, NULL); a->__sizeFQAN++)
				{	p = (char **)soap_push_block(soap, sizeof(char *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_string(soap, "ns1:FQAN", p, "xsd:string"))
						break;
					soap_flag_ns1__FQAN = 0;
				}
				a->ns1__FQAN = (char **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_ns1__FQAN && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_ns1__Target && soap->error == SOAP_TAG_MISMATCH)
			{	char **p;
				soap_new_block(soap);
				for (a->__sizeTarget = 0; !soap_element_begin_in(soap, "ns1:Target", 1, NULL); a->__sizeTarget++)
				{	p = (char **)soap_push_block(soap, sizeof(char *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_string(soap, "ns1:Target", p, "xsd:string"))
						break;
					soap_flag_ns1__Target = 0;
				}
				a->ns1__Target = (char **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_ns1__Target && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap_flag_ns1__Lifetime && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "ns1:Lifetime", &a->ns1__Lifetime, "xsd:int"))
				{	soap_flag_ns1__Lifetime--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__GetAttributeCertificate *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__GetAttributeCertificate, 0, sizeof(struct _ns1__GetAttributeCertificate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__StatusType(struct soap *soap, struct ns1__StatusType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__StatusCode = NULL;
	soap_default_string(soap, &a->ns1__StatusMessage);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__StatusType(struct soap *soap, const struct ns1__StatusType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__StatusCodeType(soap, &a->ns1__StatusCode);
	soap_serialize_string(soap, &a->ns1__StatusMessage);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__StatusType(struct soap *soap, const struct ns1__StatusType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__StatusType);
	if (soap_out_ns1__StatusType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__StatusType(struct soap *soap, const char *tag, int id, const struct ns1__StatusType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__StatusType), type);
	soap_out_PointerTons1__StatusCodeType(soap, "ns1:StatusCode", -1, &a->ns1__StatusCode, "");
	soap_out_string(soap, "ns1:StatusMessage", -1, &a->ns1__StatusMessage, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns1__StatusType * SOAP_FMAC4 soap_get_ns1__StatusType(struct soap *soap, struct ns1__StatusType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__StatusType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__StatusType * SOAP_FMAC4 soap_in_ns1__StatusType(struct soap *soap, const char *tag, struct ns1__StatusType *a, const char *type)
{
	short soap_flag_ns1__StatusCode = 1, soap_flag_ns1__StatusMessage = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__StatusType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__StatusType, sizeof(struct ns1__StatusType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__StatusType(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__StatusCode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__StatusCodeType(soap, "ns1:StatusCode", &a->ns1__StatusCode, "ns1:StatusCodeType"))
				{	soap_flag_ns1__StatusCode--;
					continue;
				}
			if (soap_flag_ns1__StatusMessage && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:StatusMessage", &a->ns1__StatusMessage, "xsd:string"))
				{	soap_flag_ns1__StatusMessage--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__StatusType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__StatusType, 0, sizeof(struct ns1__StatusType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ns1__StatusCode > 0 || soap_flag_ns1__StatusMessage > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__StatusCodeType(struct soap *soap, struct ns1__StatusCodeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__anyURI(soap, &a->Value);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__StatusCodeType(struct soap *soap, const struct ns1__StatusCodeType *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__StatusCodeType(struct soap *soap, const struct ns1__StatusCodeType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__StatusCodeType);
	if (soap_out_ns1__StatusCodeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__StatusCodeType(struct soap *soap, const char *tag, int id, const struct ns1__StatusCodeType *a, const char *type)
{
	if (a->Value)
		soap_set_attr(soap, "Value", a->Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__StatusCodeType), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns1__StatusCodeType * SOAP_FMAC4 soap_get_ns1__StatusCodeType(struct soap *soap, struct ns1__StatusCodeType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__StatusCodeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__StatusCodeType * SOAP_FMAC4 soap_in_ns1__StatusCodeType(struct soap *soap, const char *tag, struct ns1__StatusCodeType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__StatusCodeType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__StatusCodeType, sizeof(struct ns1__StatusCodeType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__StatusCodeType(soap, a);
	if (soap_s2string(soap, soap_attr_value(soap, "Value", 0), &a->Value))
		return NULL;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__StatusCodeType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__StatusCodeType, 0, sizeof(struct ns1__StatusCodeType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__GetAttributeCertificateResponse(struct soap *soap, struct _ns1__GetAttributeCertificateResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__GetAttributeCertificateResponse))
		soap_serialize__ns1__GetAttributeCertificateResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__GetAttributeCertificateResponse(struct soap *soap, struct _ns1__GetAttributeCertificateResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__GetAttributeCertificateResponse);
	if (soap_out_PointerTo_ns1__GetAttributeCertificateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__GetAttributeCertificateResponse(struct soap *soap, const char *tag, int id, struct _ns1__GetAttributeCertificateResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__GetAttributeCertificateResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__GetAttributeCertificateResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__GetAttributeCertificateResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__GetAttributeCertificateResponse(struct soap *soap, struct _ns1__GetAttributeCertificateResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__GetAttributeCertificateResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__GetAttributeCertificateResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__GetAttributeCertificateResponse(struct soap *soap, const char *tag, struct _ns1__GetAttributeCertificateResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__GetAttributeCertificateResponse **)soap_malloc(soap, sizeof(struct _ns1__GetAttributeCertificateResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__GetAttributeCertificateResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__GetAttributeCertificateResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__GetAttributeCertificateResponse, sizeof(struct _ns1__GetAttributeCertificateResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__GetAttributeCertificate(struct soap *soap, struct _ns1__GetAttributeCertificate *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__GetAttributeCertificate))
		soap_serialize__ns1__GetAttributeCertificate(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__GetAttributeCertificate(struct soap *soap, struct _ns1__GetAttributeCertificate *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__GetAttributeCertificate);
	if (soap_out_PointerTo_ns1__GetAttributeCertificate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__GetAttributeCertificate(struct soap *soap, const char *tag, int id, struct _ns1__GetAttributeCertificate *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__GetAttributeCertificate);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__GetAttributeCertificate(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__GetAttributeCertificate ** SOAP_FMAC4 soap_get_PointerTo_ns1__GetAttributeCertificate(struct soap *soap, struct _ns1__GetAttributeCertificate **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__GetAttributeCertificate(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__GetAttributeCertificate ** SOAP_FMAC4 soap_in_PointerTo_ns1__GetAttributeCertificate(struct soap *soap, const char *tag, struct _ns1__GetAttributeCertificate **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__GetAttributeCertificate **)soap_malloc(soap, sizeof(struct _ns1__GetAttributeCertificate *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__GetAttributeCertificate(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__GetAttributeCertificate **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__GetAttributeCertificate, sizeof(struct _ns1__GetAttributeCertificate), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__StatusType(struct soap *soap, struct ns1__StatusType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__StatusType))
		soap_serialize_ns1__StatusType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__StatusType(struct soap *soap, struct ns1__StatusType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__StatusType);
	if (soap_out_PointerTons1__StatusType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__StatusType(struct soap *soap, const char *tag, int id, struct ns1__StatusType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__StatusType);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__StatusType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__StatusType ** SOAP_FMAC4 soap_get_PointerTons1__StatusType(struct soap *soap, struct ns1__StatusType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__StatusType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__StatusType ** SOAP_FMAC4 soap_in_PointerTons1__StatusType(struct soap *soap, const char *tag, struct ns1__StatusType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__StatusType **)soap_malloc(soap, sizeof(struct ns1__StatusType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__StatusType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__StatusType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__StatusType, sizeof(struct ns1__StatusType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToint(struct soap *soap, int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToint(struct soap *soap, int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToint);
	if (soap_out_PointerToint(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToint(struct soap *soap, const char *tag, int id, int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_int);
	if (id < 0)
		return soap->error;
	return soap_out_int(soap, tag, id, *a, type);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_get_PointerToint(struct soap *soap, int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_in_PointerToint(struct soap *soap, const char *tag, int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (int **)soap_malloc(soap, sizeof(int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_int(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_int, sizeof(int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostring(struct soap *soap, char **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_string))
		soap_serialize_string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostring(struct soap *soap, char **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostring);
	if (soap_out_PointerTostring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostring(struct soap *soap, const char *tag, int id, char **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_string);
	if (id < 0)
		return soap->error;
	return soap_out_string(soap, tag, id, *a, type);
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_get_PointerTostring(struct soap *soap, char ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_in_PointerTostring(struct soap *soap, const char *tag, char ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (char ***)soap_malloc(soap, sizeof(char **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (char ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_string, sizeof(char *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__StatusCodeType(struct soap *soap, struct ns1__StatusCodeType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__StatusCodeType))
		soap_serialize_ns1__StatusCodeType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__StatusCodeType(struct soap *soap, struct ns1__StatusCodeType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__StatusCodeType);
	if (soap_out_PointerTons1__StatusCodeType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__StatusCodeType(struct soap *soap, const char *tag, int id, struct ns1__StatusCodeType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__StatusCodeType);
	if (id < 0)
		return soap->error;
	return soap_out_ns1__StatusCodeType(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct ns1__StatusCodeType ** SOAP_FMAC4 soap_get_PointerTons1__StatusCodeType(struct soap *soap, struct ns1__StatusCodeType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__StatusCodeType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__StatusCodeType ** SOAP_FMAC4 soap_in_PointerTons1__StatusCodeType(struct soap *soap, const char *tag, struct ns1__StatusCodeType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct ns1__StatusCodeType **)soap_malloc(soap, sizeof(struct ns1__StatusCodeType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_ns1__StatusCodeType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct ns1__StatusCodeType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__StatusCodeType, sizeof(struct ns1__StatusCodeType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__anyURI(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__anyURI(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__anyURI);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__anyURI(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__anyURI, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

#ifdef __cplusplus
}
#endif

/* End of soapC.c */
