/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.namespace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;
import org.glite.security.util.DNHandler;
import org.glite.security.util.namespace.NamespaceFormat;
import org.glite.security.util.namespace.NamespacePolicy;

public class EUGridNamespaceFormat
extends NamespaceFormat {
    static final Logger LOGGER = Logger.getLogger(EUGridNamespaceFormat.class);
    private static final String FORMAT_VERSION_1 = "#NAMESPACES-VERSION: 1.0";

    public void parse(String filename) throws IOException, ParseException {
        BufferedReader reader = null;
        try {
            File file = new File(filename);
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            StringBuffer buf = new StringBuffer();
            List<NamespacePolicy> policyList = this.getPolices();
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                ++lineNumber;
                if (this.getVersion() == null && line.contains(FORMAT_VERSION_1)) {
                    this.setVersion(FORMAT_VERSION_1);
                }
                if (line.contains("#") || line.length() <= 0) continue;
                if (line.contains("\\")) {
                    buf.append(line.substring(0, line.length() - 1));
                    continue;
                }
                buf.append(line);
                buf.append('\n');
                NamespacePolicy policy = this.createPolicy(buf.toString(), lineNumber, filename);
                if (policy != null) {
                    policyList.add(policy);
                    buf = new StringBuffer();
                    continue;
                }
                LOGGER.error((Object)("Unable to create policy pair: " + line));
            }
            if (this.getVersion() == null) {
                this.setVersion(FORMAT_VERSION_1);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParseException e) {
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NamespacePolicy createPolicy(String inputStatement, int lineNumber, String filename) throws ParseException {
        String access;
        String statement = inputStatement.toLowerCase();
        String[] split = statement.split("to issuer|deny|permit|subject");
        NamespacePolicy policy = null;
        if (split.length == 4) {
            String issuer = split[1].replace("\"", "").trim();
            String subject = split[3].replace("\"", "").trim();
            policy = new NamespacePolicy(DNHandler.getDNRFC2253(issuer), null, subject, statement, lineNumber, filename);
            access = null;
            if (statement.contains("deny")) {
                access = "deny";
                policy.subjectDNPermitted(false);
            } else {
                if (!statement.contains("permit")) throw new ParseException("No deny or allow string found in the input statement: \"" + inputStatement + "\" in file: " + filename, 0);
                access = "permit";
                policy.subjectDNPermitted(true);
            }
        } else {
            LOGGER.warn((Object)("Unable to parse policy statement from file: " + filename + ", statement was: " + statement));
            throw new ParseException("Unable to parse policy statement", lineNumber);
        }
        policy.setAccessRights(access);
        return policy;
    }
}

