/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocket;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.glite.security.util.CertUtil;
import org.glite.security.util.DN;
import org.glite.security.util.DNHandler;
import org.glite.security.util.IPAddressComparator;

public class HostNameChecker {
    private static final Logger LOGGER = Logger.getLogger(HostNameChecker.class);
    public static final Pattern ipPattern = Pattern.compile("[\\d\\.]+|[\\d\\:]+");
    public static final byte[] localhostIPv4 = IPAddressComparator.parseIP("127.0.0.1");
    public static final byte[] localhostIPv6 = IPAddressComparator.parseIP("::1");

    public static void checkHostname(String hostname, SSLSocket socket) throws IOException {
        if (!socket.isConnected()) {
            throw new IOException("Socket is not open, can't check the host certificate!");
        }
        Certificate[] certs = socket.getSession().getPeerCertificates();
        if (!(certs[0] instanceof X509Certificate)) {
            socket.close();
            throw new IOException("Non X509 certificate given during SSL/TLS handshake, couldn't handle it. Class was: " + certs[0].getClass().getName());
        }
        X509Certificate[] hostCerts = (X509Certificate[])certs;
        int hostCertIndex = CertUtil.findClientCert(hostCerts);
        X509Certificate hostCert = (X509Certificate)certs[hostCertIndex];
        try {
            if (!HostNameChecker.checkHostName(hostname, hostCert)) {
                socket.close();
                throw new IOException("Hostname " + hostname + " not allowed with certificate for DN: " + DNHandler.getSubject(hostCert).getRFCDN());
            }
        }
        catch (CertificateParsingException e) {
            socket.close();
            throw new IOException("Invalid certificate received, error was: " + e.getMessage());
        }
    }

    public static boolean checkHostName(String inHostname, X509Certificate cert) throws CertificateParsingException {
        Collection<List<?>> collection;
        String hostname = null;
        if (inHostname.indexOf(47) < 0) {
            hostname = inHostname.trim().toLowerCase();
        } else {
            try {
                URL url = new URL(inHostname.trim());
                hostname = url.getHost().toLowerCase();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Illegal URL given for the certificate host check: " + inHostname);
            }
        }
        boolean ipAsHostname = false;
        if (ipPattern.matcher(hostname).matches()) {
            ipAsHostname = true;
        }
        if (ipAsHostname) {
            byte[] hostnameIPBytes = IPAddressComparator.parseIP(hostname);
            if (hostnameIPBytes.length < 6) {
                if (IPAddressComparator.compare(hostnameIPBytes, localhostIPv4)) {
                    LOGGER.debug((Object)"Localhost IPv4 address given, bypassing hostname - certificate matching.");
                    return true;
                }
            } else if (IPAddressComparator.compare(hostnameIPBytes, localhostIPv6)) {
                LOGGER.debug((Object)"Localhost IPv6 address given, bypassing hostname - certificate matching.");
                return true;
            }
        } else if (hostname.equals("localhost")) {
            LOGGER.debug((Object)"Localhost address given, bypassing hostname - certificate matching.");
            return true;
        }
        if ((collection = cert.getSubjectAlternativeNames()) != null) {
            for (List<?> item : collection) {
                int type = (Integer)item.get(0);
                if (type == 2) {
                    if (ipAsHostname) continue;
                    String dnsName = (String)item.get(1);
                    if (HostNameChecker.checkDNS(hostname, dnsName)) {
                        return true;
                    }
                    LOGGER.debug((Object)("Hostname \"" + hostname + "\" does not match \"" + dnsName + "\"."));
                    continue;
                }
                if (type != 7 || !ipAsHostname) continue;
                String ipString = (String)item.get(1);
                if (HostNameChecker.checkIP(hostname, ipString)) {
                    return true;
                }
                LOGGER.debug((Object)("Hostname \"" + hostname + "\" does not match \"" + ipString + "\"."));
            }
        }
        if (HostNameChecker.checkBasedOnDN(hostname, cert)) {
            return true;
        }
        LOGGER.debug((Object)("Hostname \"" + hostname + "\" does not match DN \"" + DNHandler.getSubject(cert).getRFCDN() + "\"."));
        return false;
    }

    private static boolean checkBasedOnDN(String hostname, X509Certificate cert) {
        X500Principal principal = cert.getSubjectX500Principal();
        return principal != null && !"".equals(principal.getName()) && HostNameChecker.checkDN(hostname, DNHandler.getDN(principal));
    }

    private static boolean checkIP(String hostname, String ip) {
        byte[] ipHostname;
        byte[] ipAltName = IPAddressComparator.parseIP(ip);
        if (ipAltName.length == (ipHostname = IPAddressComparator.parseIP(hostname)).length) {
            return IPAddressComparator.compare(ipAltName, ipHostname);
        }
        return false;
    }

    private static boolean checkDNS(String hostname, String dnsName) {
        if (dnsName.indexOf(42) < 0) {
            if (hostname.trim().equalsIgnoreCase(dnsName)) {
                return true;
            }
        } else {
            String regexp = dnsName.replaceAll("\\*", "[^\\.]*");
            if (hostname.toLowerCase().matches(regexp.toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    private static boolean checkDN(String hostname, DN dn) {
        String cnValue = dn.getLastCNValue();
        if (cnValue == null) {
            return false;
        }
        int index = cnValue.indexOf(47);
        if (index >= 0) {
            cnValue = cnValue.substring(index + 1, cnValue.length());
        }
        return HostNameChecker.checkDNS(hostname, cnValue);
    }
}

