/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager;

import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Calendar;
import org.glite.security.trustmanager.InstanceID;
import org.glite.security.trustmanager.OpensslTrustmanager;
import org.glite.security.util.CaseInsensitiveProperties;

public class OpensslTrustmanagerFactory {
    private static InstanceID latestID = null;
    private static OpensslTrustmanager latestManager = null;
    private static Calendar lastUpdate = null;
    private static final int UPDATE_INTERVAL_H = 2;

    public static synchronized OpensslTrustmanager getTrustmanager(String id, String path, boolean crlRequired) throws IOException, CertificateException, NoSuchProviderException, ParseException {
        InstanceID newID = new InstanceID(id, path, crlRequired);
        if (latestID != null && newID.equals(latestID)) {
            Calendar cutoffTime = Calendar.getInstance();
            cutoffTime.add(11, -2);
            if (cutoffTime.after(lastUpdate)) {
                latestManager.checkUpdate();
            }
            return latestManager;
        }
        latestID = newID;
        latestManager = new OpensslTrustmanager(path, crlRequired, null);
        lastUpdate = Calendar.getInstance();
        return latestManager;
    }

    public static synchronized OpensslTrustmanager getTrustmanager(String id, String path, boolean crlRequired, CaseInsensitiveProperties props) throws IOException, CertificateException, NoSuchProviderException, ParseException {
        InstanceID newID = new InstanceID(id, path, crlRequired);
        if (latestID != null && newID.equals(latestID)) {
            Calendar cutoffTime = Calendar.getInstance();
            cutoffTime.add(11, -2);
            if (cutoffTime.after(lastUpdate)) {
                latestManager.checkUpdate();
            }
            return latestManager;
        }
        latestID = newID;
        latestManager = new OpensslTrustmanager(path, crlRequired, props);
        lastUpdate = Calendar.getInstance();
        return latestManager;
    }
}

