/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager.axis;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.axis.transport.http.SocketHolder;
import org.glite.security.trustmanager.ContextWrapper;
import org.glite.security.util.HostNameChecker;

public class SSLConfigSender
extends HTTPSender {
    private static final long serialVersionUID = 9079875049535134492L;
    private Properties m_sslConfig = null;

    public SSLConfigSender(Properties properties) throws AxisFault {
        this.m_sslConfig = properties;
    }

    public static SimpleProvider getTransportProvider(Properties config) throws AxisFault {
        SimpleProvider transportProvider = new SimpleProvider();
        SSLConfigSender sslHandler = new SSLConfigSender(config);
        SimpleTargetedChain transport = new SimpleTargetedChain((Handler)new SimpleChain(), (Handler)sslHandler, (Handler)new SimpleChain());
        transportProvider.deployTransport("http", (Handler)transport);
        return transportProvider;
    }

    protected void getSocket(SocketHolder sockHolder, MessageContext msgContext, String protocol, String host, int port, int timeout, StringBuffer otherHeaders, BooleanHolder useFullURL) throws IOException, GeneralSecurityException, Exception {
        if (protocol.equalsIgnoreCase("https")) {
            ContextWrapper contextWrapper = new ContextWrapper(this.m_sslConfig);
            SSLSocketFactory fac = contextWrapper.getSocketFactory();
            SSLSocket socket = (SSLSocket)fac.createSocket();
            socket.setEnabledProtocols(new String[]{contextWrapper.getContext().getProtocol()});
            socket.setUseClientMode(true);
            if (timeout >= 0) {
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket.setSoTimeout(timeout);
            } else {
                socket.connect(new InetSocketAddress(host, port));
            }
            String checkHostname = this.m_sslConfig.getProperty("hostnameCheck", "true").trim().toLowerCase();
            if (checkHostname.startsWith("t") || checkHostname.startsWith("y")) {
                HostNameChecker.checkHostname((String)host, (SSLSocket)socket);
            }
            sockHolder.setSocket((Socket)socket);
        } else {
            super.getSocket(sockHolder, msgContext, protocol, host, port, timeout, otherHeaders, useFullURL);
        }
    }
}

