/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util.proxy;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class ProxyTracingExtension {
    public static final String PROXY_TRACING_ISSUER_EXTENSION_OID = "1.2.840.113612.5.5.1.1.1.1";
    public static final String PROXY_TRACING_SUBJECT_EXTENSION_OID = "1.2.840.113612.5.5.1.1.1.2";
    public static final int ISSUER_EXTENSION = 1;
    public static final int SUBJECT_EXTENSION = 2;
    private GeneralNames m_names = null;
    private GeneralName m_name = null;

    public ProxyTracingExtension(String url) {
        this.m_name = new GeneralName(6, url);
        this.m_names = new GeneralNames(this.m_name);
    }

    public ProxyTracingExtension(byte[] bytes) throws IOException {
        this.m_names = new GeneralNames((ASN1Sequence)ASN1Object.fromByteArray((byte[])bytes));
        this.m_name = this.m_names.getNames()[0];
    }

    public String getURL() {
        if (this.m_name.getTagNo() != 6) {
            return null;
        }
        DERIA5String ia5String = (DERIA5String)this.m_name.getName();
        return ia5String.getString();
    }

    public GeneralNames getNames() {
        return this.m_names;
    }
}

