/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.GeneralName;

public class IPAddressComparator {
    private static final Logger LOGGER = Logger.getLogger(IPAddressComparator.class);

    public static byte[] parseIP(String ip) {
        GeneralName name = new GeneralName(7, ip);
        return ASN1OctetString.getInstance((Object)name.getName()).getOctets();
    }

    public static boolean compare(byte[] item1, byte[] item2) {
        if (item1.length != item2.length) {
            LOGGER.error((Object)("Illegal array sizes given for compare operation, sizes must match, sizes were: " + item1.length + " and " + item2.length + "."));
            throw new IllegalArgumentException("Illegal array sizes given for compare operation, sizes must match, sizes were" + item1.length + " and " + item2.length + ".");
        }
        for (int i = 0; i < item1.length; ++i) {
            if (item1[i] == item2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isWithinAddressSpace(byte[] ipAddress, byte[] ipAddressWithNetmask) {
        if (!(ipAddressWithNetmask.length == 8 && ipAddress.length == 4 || ipAddressWithNetmask.length == 32 && ipAddress.length == 16)) {
            LOGGER.error((Object)("IP address and IP address-netmask length mismatch, should be either (4 and 8) or (16 and 32) lengths were: " + ipAddress.length + " and " + ipAddressWithNetmask.length + "."));
            throw new IllegalArgumentException("IP address and IP address-netmask length mismatch, should be either (4 and 8) or (16 and 32) lengths were: " + ipAddress.length + " and " + ipAddressWithNetmask.length + ".");
        }
        byte[] comparatorIP = IPAddressComparator.copyBytes(ipAddressWithNetmask, 0, ipAddressWithNetmask.length / 2);
        byte[] netmask = IPAddressComparator.copyBytes(ipAddressWithNetmask, ipAddressWithNetmask.length / 2, ipAddressWithNetmask.length);
        byte[] resultComparator = IPAddressComparator.andBytes(comparatorIP, netmask);
        byte[] resultIP = IPAddressComparator.andBytes(ipAddress, netmask);
        return IPAddressComparator.compare(resultComparator, resultIP);
    }

    public static byte[] andBytes(byte[] ip, byte[] netmask) {
        if (ip.length != netmask.length) {
            LOGGER.error((Object)("Illegal array sizes given for and operation, sizes must match, sizes were: " + ip.length + " and " + netmask.length + "."));
            throw new IllegalArgumentException("Illegal array sizes given for and operation, sizes must match, sizes were: " + ip.length + " and " + netmask.length + ".");
        }
        byte[] result = new byte[ip.length];
        for (int i = 0; i < ip.length; ++i) {
            Integer integer = ip[i] & 0xFF & (netmask[i] & 0xFF);
            result[i] = integer.byteValue();
        }
        return result;
    }

    public static byte[] copyBytes(byte[] array, int start, int end) {
        if (end < start) {
            LOGGER.error((Object)("Illegal start or end index for array copy, end must be bigger than start start was: " + start + " and end: " + end + "."));
            throw new IllegalArgumentException("Illegal start or end index for array copy, end must be bigger than start start was: " + start + " and end: " + end + ".");
        }
        if (end > array.length) {
            LOGGER.error((Object)("Illegal end index for array copy, end must be smaller than the array size end index was: " + end + " and array length: " + array.length + "."));
            throw new ArrayIndexOutOfBoundsException("Illegal end index for array copy, end must be smaller than or equal to the array size. End index was: " + end + " and array size: " + array.length + ".");
        }
        byte[] newBytes = new byte[end - start];
        for (int i = start; i < end; ++i) {
            newBytes[i - start] = array[i];
        }
        return newBytes;
    }

    public static byte[][] concatArrayArrays(byte[][] first, byte[][] second) {
        int i;
        if (first == null || second == null) {
            throw new IllegalArgumentException("Invalid argument, null give even though it is not allowed.");
        }
        byte[][] newByteArrays = new byte[first.length][second.length];
        for (i = 0; i < first.length; ++i) {
            newByteArrays[i] = first[i];
        }
        for (i = 0; i < second.length; ++i) {
            newByteArrays[i + first.length] = second[i];
        }
        return newByteArrays;
    }
}

