/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.x509.X509Name;
import org.glite.security.util.DN;
import org.glite.security.util.DNImplRFC2253;

public class DNHandler {
    static final Logger LOGGER = Logger.getLogger(DNHandler.class);
    public static Hashtable s_rfc2253v2Lookup = (Hashtable)X509Name.RFC2253Symbols.clone();
    public static Hashtable s_rfc2253Lookup;

    public static DN getIssuer(X509Certificate cert) {
        return DNHandler.getDN(cert.getIssuerDN());
    }

    public static DN getSubject(X509Certificate cert) {
        return DNHandler.getDN(cert.getSubjectDN());
    }

    public static DN getDN(Principal principal) {
        return new DNImplRFC2253(principal);
    }

    public static DN getDN(X509Name x509Name) {
        return new DNImplRFC2253(x509Name);
    }

    public static DN getDN(String inputDN) {
        return new DNImplRFC2253(inputDN, false);
    }

    public static DN getDNRFC2253(String inputDN) {
        return new DNImplRFC2253(inputDN);
    }

    static {
        s_rfc2253v2Lookup.put(X509Name.EmailAddress, "emailAddress");
        s_rfc2253Lookup = (Hashtable)X509Name.DefaultSymbols.clone();
        s_rfc2253Lookup.put(X509Name.EmailAddress, "Email");
        X509Name.DefaultLookUp.put("email", X509Name.E);
        X509Name.DefaultLookUp.put("serialnumber", X509Name.SN);
    }
}

