/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <activemq/wireformat/openwire/marshal/v2/ConsumerInfoMarshaller.h>

#include <activemq/commands/ConsumerInfo.h>
#include <activemq/exceptions/ActiveMQException.h>
#include <decaf/lang/Pointer.h>

//
//     NOTE!: This file is autogenerated - do not modify!
//            if you need to make a change, please see the Java Classes in the
//            activemq-core module
//

using namespace std;
using namespace activemq;
using namespace activemq::exceptions;
using namespace activemq::commands;
using namespace activemq::wireformat;
using namespace activemq::wireformat::openwire;
using namespace activemq::wireformat::openwire::marshal;
using namespace activemq::wireformat::openwire::utils;
using namespace activemq::wireformat::openwire::marshal::v2;
using namespace decaf;
using namespace decaf::io;
using namespace decaf::lang;

///////////////////////////////////////////////////////////////////////////////
DataStructure* ConsumerInfoMarshaller::createObject() const {
    return new ConsumerInfo();
}

///////////////////////////////////////////////////////////////////////////////
unsigned char ConsumerInfoMarshaller::getDataStructureType() const {
    return ConsumerInfo::ID_CONSUMERINFO;
}

///////////////////////////////////////////////////////////////////////////////
void ConsumerInfoMarshaller::tightUnmarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        BaseCommandMarshaller::tightUnmarshal( wireFormat, dataStructure, dataIn, bs );

        ConsumerInfo* info =
            dynamic_cast<ConsumerInfo*>( dataStructure );
        info->setConsumerId( Pointer<ConsumerId>( dynamic_cast< ConsumerId* >(
            tightUnmarshalCachedObject( wireFormat, dataIn, bs ) ) ) );
        info->setBrowser( bs->readBoolean() );
        info->setDestination( Pointer<ActiveMQDestination>( dynamic_cast< ActiveMQDestination* >(
            tightUnmarshalCachedObject( wireFormat, dataIn, bs ) ) ) );
        info->setPrefetchSize( dataIn->readInt() );
        info->setMaximumPendingMessageLimit( dataIn->readInt() );
        info->setDispatchAsync( bs->readBoolean() );
        info->setSelector( tightUnmarshalString( dataIn, bs ) );
        info->setSubscriptionName( tightUnmarshalString( dataIn, bs ) );
        info->setNoLocal( bs->readBoolean() );
        info->setExclusive( bs->readBoolean() );
        info->setRetroactive( bs->readBoolean() );
        info->setPriority( dataIn->readByte() );

        if( bs->readBoolean() ) {
            short size = dataIn->readShort();
            info->getBrokerPath().reserve( size );
            for( int i = 0; i < size; i++ ) {
                info->getBrokerPath().push_back( Pointer<BrokerId>( dynamic_cast< BrokerId* >(
                    tightUnmarshalNestedObject( wireFormat, dataIn, bs ) ) ) );
            }
        }
        else {
            info->getBrokerPath().clear();
        }
        info->setAdditionalPredicate( Pointer<BooleanExpression>( dynamic_cast< BooleanExpression* >(
            tightUnmarshalNestedObject( wireFormat, dataIn, bs ) ) ) );
        info->setNetworkSubscription( bs->readBoolean() );
        info->setOptimizedAcknowledge( bs->readBoolean() );
        info->setNoRangeAcks( bs->readBoolean() );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
int ConsumerInfoMarshaller::tightMarshal1( OpenWireFormat* wireFormat, DataStructure* dataStructure, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        ConsumerInfo* info =
            dynamic_cast<ConsumerInfo*>( dataStructure );

        int rc = BaseCommandMarshaller::tightMarshal1( wireFormat, dataStructure, bs );
        rc += tightMarshalCachedObject1( wireFormat, info->getConsumerId().get(), bs );
        bs->writeBoolean( info->isBrowser() );
        rc += tightMarshalCachedObject1( wireFormat, info->getDestination().get(), bs );
        bs->writeBoolean( info->isDispatchAsync() );
        rc += tightMarshalString1( info->getSelector(), bs );
        rc += tightMarshalString1( info->getSubscriptionName(), bs );
        bs->writeBoolean( info->isNoLocal() );
        bs->writeBoolean( info->isExclusive() );
        bs->writeBoolean( info->isRetroactive() );
        rc += tightMarshalObjectArray1( wireFormat, info->getBrokerPath(), bs );
        rc += tightMarshalNestedObject1( wireFormat, info->getAdditionalPredicate().get(), bs );
        bs->writeBoolean( info->isNetworkSubscription() );
        bs->writeBoolean( info->isOptimizedAcknowledge() );
        bs->writeBoolean( info->isNoRangeAcks() );

        return rc + 9;
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void ConsumerInfoMarshaller::tightMarshal2( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut, BooleanStream* bs ) throw( decaf::io::IOException ) {

    try {

        BaseCommandMarshaller::tightMarshal2( wireFormat, dataStructure, dataOut, bs );

        ConsumerInfo* info =
            dynamic_cast<ConsumerInfo*>( dataStructure );
        tightMarshalCachedObject2( wireFormat, info->getConsumerId().get(), dataOut, bs );
        bs->readBoolean();
        tightMarshalCachedObject2( wireFormat, info->getDestination().get(), dataOut, bs );
        dataOut->writeInt( info->getPrefetchSize() );
        dataOut->writeInt( info->getMaximumPendingMessageLimit() );
        bs->readBoolean();
        tightMarshalString2( info->getSelector(), dataOut, bs );
        tightMarshalString2( info->getSubscriptionName(), dataOut, bs );
        bs->readBoolean();
        bs->readBoolean();
        bs->readBoolean();
        dataOut->write( info->getPriority() );
        tightMarshalObjectArray2( wireFormat, info->getBrokerPath(), dataOut, bs );
        tightMarshalNestedObject2( wireFormat, info->getAdditionalPredicate().get(), dataOut, bs );
        bs->readBoolean();
        bs->readBoolean();
        bs->readBoolean();
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void ConsumerInfoMarshaller::looseUnmarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataInputStream* dataIn ) throw( decaf::io::IOException ) {

    try {

        BaseCommandMarshaller::looseUnmarshal( wireFormat, dataStructure, dataIn );
        ConsumerInfo* info =
            dynamic_cast<ConsumerInfo*>( dataStructure );
        info->setConsumerId( Pointer<ConsumerId>( dynamic_cast< ConsumerId* >( 
            looseUnmarshalCachedObject( wireFormat, dataIn ) ) ) );
        info->setBrowser( dataIn->readBoolean() );
        info->setDestination( Pointer<ActiveMQDestination>( dynamic_cast< ActiveMQDestination* >( 
            looseUnmarshalCachedObject( wireFormat, dataIn ) ) ) );
        info->setPrefetchSize( dataIn->readInt() );
        info->setMaximumPendingMessageLimit( dataIn->readInt() );
        info->setDispatchAsync( dataIn->readBoolean() );
        info->setSelector( looseUnmarshalString( dataIn ) );
        info->setSubscriptionName( looseUnmarshalString( dataIn ) );
        info->setNoLocal( dataIn->readBoolean() );
        info->setExclusive( dataIn->readBoolean() );
        info->setRetroactive( dataIn->readBoolean() );
        info->setPriority( dataIn->readByte() );

        if( dataIn->readBoolean() ) {
            short size = dataIn->readShort();
            info->getBrokerPath().reserve( size );
            for( int i = 0; i < size; i++ ) {
                info->getBrokerPath().push_back( Pointer<BrokerId>( dynamic_cast<BrokerId* >(
                    looseUnmarshalNestedObject( wireFormat, dataIn ) ) ) );
            }
        }
        else {
            info->getBrokerPath().clear();
        }
        info->setAdditionalPredicate( Pointer<BooleanExpression>( dynamic_cast< BooleanExpression* >( 
            looseUnmarshalNestedObject( wireFormat, dataIn ) ) ) );
        info->setNetworkSubscription( dataIn->readBoolean() );
        info->setOptimizedAcknowledge( dataIn->readBoolean() );
        info->setNoRangeAcks( dataIn->readBoolean() );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

///////////////////////////////////////////////////////////////////////////////
void ConsumerInfoMarshaller::looseMarshal( OpenWireFormat* wireFormat, DataStructure* dataStructure, DataOutputStream* dataOut ) throw( decaf::io::IOException ) {

    try {

        ConsumerInfo* info =
            dynamic_cast<ConsumerInfo*>( dataStructure );
        BaseCommandMarshaller::looseMarshal( wireFormat, dataStructure, dataOut );

        looseMarshalCachedObject( wireFormat, info->getConsumerId().get(), dataOut );
        dataOut->writeBoolean( info->isBrowser() );
        looseMarshalCachedObject( wireFormat, info->getDestination().get(), dataOut );
        dataOut->writeInt( info->getPrefetchSize() );
        dataOut->writeInt( info->getMaximumPendingMessageLimit() );
        dataOut->writeBoolean( info->isDispatchAsync() );
        looseMarshalString( info->getSelector(), dataOut );
        looseMarshalString( info->getSubscriptionName(), dataOut );
        dataOut->writeBoolean( info->isNoLocal() );
        dataOut->writeBoolean( info->isExclusive() );
        dataOut->writeBoolean( info->isRetroactive() );
        dataOut->write( info->getPriority() );
        looseMarshalObjectArray( wireFormat, info->getBrokerPath(), dataOut );
        looseMarshalNestedObject( wireFormat, info->getAdditionalPredicate().get(), dataOut );
        dataOut->writeBoolean( info->isNetworkSubscription() );
        dataOut->writeBoolean( info->isOptimizedAcknowledge() );
        dataOut->writeBoolean( info->isNoRangeAcks() );
    }
    AMQ_CATCH_RETHROW( decaf::io::IOException )
    AMQ_CATCH_EXCEPTION_CONVERT( exceptions::ActiveMQException, decaf::io::IOException )
    AMQ_CATCHALL_THROW( decaf::io::IOException )
}

