/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.glite.security.util.CAFilenameSplitter;
import org.glite.security.util.CaseInsensitiveProperties;
import org.glite.security.util.CertificateNotFoundException;
import org.glite.security.util.DNHandler;
import org.glite.security.util.FileCertReader;
import org.glite.security.util.RevocationChecker;
import org.glite.security.util.namespace.EUGridNamespaceFormat;
import org.glite.security.util.namespace.LegacyNamespaceFormat;
import org.glite.security.util.namespace.NamespaceFormat;

public class FullTrustAnchor {
    private static final Logger LOGGER = Logger.getLogger(FullTrustAnchor.class);
    public static final String IGTF_NAMESPACE_ENDING = ".namespaces";
    public static final String GLOBUS_NAMESPACE_ENDING = ".signing_policy";
    public static final String CRL_FILE_ENDING_PREFIX = ".r";
    public static final String REVOCATION_CHECKER_CLASS = "revocationChecker";
    private static final String REVOCATION_CHECKER_CLASS_DEFAULT = "org.glite.security.util.FileCRLChecker";
    static FileCertReader s_certReader;
    public String m_caHash;
    public String m_baseFilename;
    public int m_caNumber;
    public X509Certificate m_caCert;
    public long m_caModified;
    public NamespaceFormat m_namespace;
    public String m_namespaceFilename;
    public long m_namespaceModified;
    public long m_lastUpdateCheck;
    public RevocationChecker m_revChecker;
    private String m_revCheckerClass;
    private CaseInsensitiveProperties m_props;
    public boolean m_crlEnabled = true;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TrustAnchor hash: ");
        buf.append(this.m_caHash);
        buf.append(" DN: ");
        buf.append(DNHandler.getSubject(this.m_caCert).toString());
        buf.append("\n modified: ");
        buf.append(this.m_caModified);
        buf.append("\n RevocationChecker: ");
        buf.append(this.m_revChecker);
        buf.append("\n nameSpace from " + this.m_namespaceFilename + ": ");
        buf.append(this.m_namespace);
        buf.append("\n namespace modified: ");
        buf.append(this.m_namespaceModified);
        buf.append("\n last update check: ");
        buf.append(this.m_lastUpdateCheck);
        return buf.toString();
    }

    FullTrustAnchor(String caFilename, CaseInsensitiveProperties props) throws IOException, CertificateException {
        this.initCAInfo(caFilename, props);
    }

    private void initCAInfo(String caFilename, CaseInsensitiveProperties props) throws IOException, CertificateException {
        String crlEnabledText;
        if (caFilename == null || caFilename.length() == 0) {
            throw new IOException("Can't initialize a trustanchor without filename.");
        }
        CAFilenameSplitter parts = CAFilenameSplitter.splitCAFilename(caFilename);
        this.m_caHash = parts.m_hash;
        this.m_caNumber = parts.m_number;
        this.m_baseFilename = parts.m_baseFilename;
        this.m_props = props;
        this.loadCACert(this.m_baseFilename + "." + this.m_caNumber);
        try {
            this.m_caCert.checkValidity();
        }
        catch (CertificateNotYetValidException e) {
            throw new CertificateNotYetValidException(DNHandler.getSubject(this.m_caCert).getRFCDN() + " " + e.getMessage());
        }
        catch (CertificateExpiredException e) {
            throw new CertificateExpiredException(DNHandler.getSubject(this.m_caCert).getRFCDN() + " " + e.getMessage());
        }
        if (this.m_caCert.getBasicConstraints() == -1) {
            LOGGER.error((Object)("The CA certificate " + DNHandler.getSubject(this.m_caCert).getRFCDN() + " is an invalid CA as it doesn't have the required CA basic constraints extension."));
            throw new CertificateException("The CA certificate " + DNHandler.getSubject(this.m_caCert).getRFCDN() + " is an invalid CA as it doesn't have the required CA basic constraints extension.");
        }
        if (this.m_caCert.getKeyUsage() == null || !this.m_caCert.getKeyUsage()[5]) {
            LOGGER.error((Object)("The CA certificate " + DNHandler.getSubject(this.m_caCert).getRFCDN() + " is an invalid CA as it doesn't have the required keyCertSign flag set."));
            throw new CertificateException("The CA certificate " + DNHandler.getSubject(this.m_caCert).getRFCDN() + " is an invalid CA as it doesn't have the required keyCertSign flag set.");
        }
        this.m_caCert.getNonCriticalExtensionOIDs();
        if (props != null && ((crlEnabledText = (crlEnabledText = props.getProperty("crlEnabled")) != null ? crlEnabledText.trim().toLowerCase() : "true").startsWith("f") || crlEnabledText.startsWith("n"))) {
            this.m_crlEnabled = false;
        }
        if (this.m_crlEnabled) {
            if (props != null) {
                this.m_revCheckerClass = props.get(REVOCATION_CHECKER_CLASS);
            }
            if (this.m_revCheckerClass == null || this.m_revCheckerClass.length() < 1) {
                this.m_revCheckerClass = REVOCATION_CHECKER_CLASS_DEFAULT;
            }
            this.tryInitRevocationChecker();
        }
        this.tryLoadNamespace(this.m_baseFilename);
    }

    private void tryInitRevocationChecker() {
        try {
            Class<?> c = Class.forName(this.m_revCheckerClass);
            Constructor<?> constructor = c.getConstructor(X509Certificate.class, String.class, Integer.TYPE, CaseInsensitiveProperties.class);
            this.m_revChecker = (RevocationChecker)constructor.newInstance(this.m_caCert, this.m_baseFilename, this.m_caNumber, this.m_props);
        }
        catch (InvocationTargetException e) {
            LOGGER.warn((Object)("Certificate revocation checker creation for CA " + this.m_baseFilename + "." + this.m_caNumber + " failed, depending on configuration the certificates from the CA " + DNHandler.getSubject(this.m_caCert).getRFCDN() + " might be refused. Error was: " + e.getCause().getMessage()));
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Certificate revocation checker for CA " + this.m_baseFilename + "." + this.m_caNumber + " failed, depending on configuration the certificates from the CA " + DNHandler.getSubject(this.m_caCert).getRFCDN() + " might be refused. Error was: " + e.getClass()), (Throwable)e);
        }
    }

    void loadCACert(String filename) throws CertificateException, IOException {
        Vector certs = s_certReader.readCerts(filename);
        this.m_caCert = (X509Certificate)certs.get(0);
        File file = new File(filename);
        this.m_caModified = file.lastModified();
    }

    void tryLoadNamespace(String baseFilename) {
        try {
            this.loadNamespace(baseFilename);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn((Object)("Namespace restrictions loading for CA " + this.m_baseFilename + "." + this.m_caNumber + " failed, namespace is not restricted. Error was: " + e.getMessage()), (Throwable)e);
            }
            LOGGER.warn((Object)("Namespace restrictions loading for CA " + this.m_baseFilename + "." + this.m_caNumber + " failed, namespace is not restricted. Error was: " + e.getMessage()));
        }
    }

    void loadNamespace(String filenameBase) throws IOException, ParseException {
        File file = new File(filenameBase + IGTF_NAMESPACE_ENDING);
        if (file.exists()) {
            try {
                this.m_namespaceFilename = filenameBase + IGTF_NAMESPACE_ENDING;
                this.m_namespace = new EUGridNamespaceFormat();
                this.m_namespace.parse(this.m_namespaceFilename);
                this.m_namespaceModified = file.lastModified();
                LOGGER.debug((Object)("loaded: " + this.m_namespaceFilename));
                return;
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Parsing of " + this.m_namespaceFilename + " failed! Falling back to the " + GLOBUS_NAMESPACE_ENDING + " file. Error was: " + e.getMessage()));
            }
        }
        this.m_namespaceFilename = filenameBase + GLOBUS_NAMESPACE_ENDING;
        this.m_namespace = new LegacyNamespaceFormat();
        this.m_namespace.parse(this.m_namespaceFilename);
        file = new File(this.m_namespaceFilename);
        this.m_namespaceModified = file.lastModified();
        LOGGER.debug((Object)("loaded: " + this.m_namespaceFilename));
    }

    void checkUpdate() throws CertificateException, IOException, CertificateNotFoundException {
        File namespaceFile;
        block11: {
            try {
                File caFile = new File(this.m_baseFilename + "." + this.m_caNumber);
                if (caFile.exists()) {
                    if (caFile.lastModified() != this.m_caModified) {
                        LOGGER.debug((Object)("CA file changed, reloading it: " + caFile));
                        this.loadCACert(caFile.getAbsolutePath());
                    }
                    break block11;
                }
                throw new CertificateNotFoundException("The CA file " + caFile.getName() + " can't be found anymore.");
            }
            catch (CertificateNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CertificateException("Error loading a CA: " + e.getMessage());
            }
        }
        if (this.m_revChecker != null) {
            this.m_revChecker.checkUpdate();
        } else if (this.m_crlEnabled) {
            this.tryInitRevocationChecker();
        }
        if (!this.m_namespaceFilename.equals(this.m_baseFilename + IGTF_NAMESPACE_ENDING)) {
            namespaceFile = new File(this.m_baseFilename + IGTF_NAMESPACE_ENDING);
            LOGGER.debug((Object)("new format namespace found when old format used, trying to load new format: " + namespaceFile.getName()));
            this.tryLoadNamespace(this.m_baseFilename);
        } else {
            namespaceFile = new File(this.m_namespaceFilename);
            if (namespaceFile.lastModified() != this.m_namespaceModified) {
                LOGGER.debug((Object)("Namespace file changed, reloading it: " + namespaceFile.getName()));
                this.tryLoadNamespace(this.m_baseFilename);
            }
        }
    }

    static {
        try {
            s_certReader = new FileCertReader();
        }
        catch (CertificateException e) {
            throw new RuntimeException("Security provider initialization failed: " + e.getMessage(), e);
        }
    }
}

