/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager.axis;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.log4j.Logger;
import org.glite.security.trustmanager.ContextWrapper;
import org.glite.security.util.HostNameChecker;

public class AXISSocketFactory
implements SecureSocketFactory {
    private static final Logger LOGGER = Logger.getLogger((String)"org.glite.security.trustmanager.axis.AXISSocketFactory");
    private static ThreadLocal theAXISSocketFactoryProperties = new ThreadLocal();

    public static Properties getCurrentProperties() {
        Properties thisProperties = (Properties)theAXISSocketFactoryProperties.get();
        if (thisProperties == null) {
            thisProperties = System.getProperties();
        }
        return thisProperties;
    }

    public static void clearCurrentProperties() {
        theAXISSocketFactoryProperties.set(null);
    }

    public static void setCurrentProperties(Properties cp) {
        theAXISSocketFactoryProperties.set(cp);
    }

    public AXISSocketFactory(Hashtable attributes) {
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        try {
            ContextWrapper contextWrapper = new ContextWrapper(AXISSocketFactory.getCurrentProperties());
            SSLSocketFactory fac = contextWrapper.getSocketFactory();
            SSLSocket socket = (SSLSocket)fac.createSocket();
            socket.setEnabledProtocols(new String[]{contextWrapper.getContext().getProtocol()});
            String timeoutString = AXISSocketFactory.getCurrentProperties().getProperty("sslTimeout", "60000");
            int timeout = Integer.parseInt(timeoutString);
            socket.setSoTimeout(timeout);
            socket.connect(new InetSocketAddress(host, port), timeout);
            String checkHostname = AXISSocketFactory.getCurrentProperties().getProperty("hostnameCheck", "true").trim().toLowerCase();
            if (checkHostname.startsWith("t") || checkHostname.startsWith("y")) {
                HostNameChecker.checkHostname((String)host, (SSLSocket)socket);
            }
            return socket;
        }
        catch (Exception e) {
            LOGGER.fatal((Object)("create() : SSL socket creation failed : " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public Object createServerFactory() throws Exception {
        LOGGER.info((Object)"createServerFactory() : Creating a server factory");
        try {
            ContextWrapper contextWrapper = new ContextWrapper(AXISSocketFactory.getCurrentProperties());
            return contextWrapper.getServerSocketFactory();
        }
        catch (Exception e) {
            LOGGER.fatal((Object)("SSL socket factory creation failed : " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }
}

